<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Sala;
class DniController extends Controller
{
    /**
     * Muestra la vista de búsqueda de DNI.
     */
    public function index()
    {
        return view('alquileres.create'); // Vista donde se encuentra el formulario
    }

    /**
     * Realiza la búsqueda del cliente por DNI utilizando la API de Perudevs.
     */
    public function search(Request $request)
    {
        // Validar que se haya ingresado un DNI
        $request->validate([
            'dni' => 'required|digits:8', // Solo acepta 8 dígitos
        ]);

        $dni = $request->input('dni');
        $apiKey = 'cGVydWRldnMucHJvZHVjdGlvbi5maXRjb2RlcnMuNjdlYjNkNzU5ZmE0MTczZjYxMzIwOGRh'; // Reemplaza con tu API Key

        $url = "https://api.perudevs.com/api/v1/dni/complete?document={$dni}&key={$apiKey}";

        // Inicializar CURL
        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ]);

        $response = curl_exec($curl);
        curl_close($curl);

        // Convertimos la respuesta JSON a un array
        $data = json_decode($response, true);

        // Si la API no devuelve datos, mostrar un mensaje predeterminado
        if (!isset($data['nombre_completo'])) {
            $data['nombre_completo'] = 'Cliente no encontrado';
             // Cargar solo salas disponibles
    $salas = Sala::where('estado', 'disponible')->get();
        }

        // Retornar la vista con los datos obtenidos
        return view('alquileres.create', compact('data','salas'));
    }
}
