<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Alquiler extends Model
{
    use HasFactory;

    protected $table = 'alquileres'; // ✅ Asegura que Laravel use la tabla correcta

    // ✅ Añadimos 'metodo_pago' aquí
    protected $fillable = [
        'pelicula_id',
        'sala_id',
        'cliente',
        'hora_entrada',
        'hora_salida',
        'precio',
        'metodo_pago', // <- ESTA LÍNEA ES CLAVE
        'estado',       // también añade esto si estás cambiando el estado
    ];

    // ✅ Relación con la película
    public function pelicula()
    {
        return $this->belongsTo(Pelicula::class, 'pelicula_id', 'id');
    }

    // ✅ Relación con la sala
    public function sala()
    {
        return $this->belongsTo(Sala::class, 'sala_id', 'id');
    }

    // ✅ Relación con cliente
    public function cliente()
    {
        return $this->belongsTo(Cliente::class);
    }

    
    // ✅ Relación con productos
    public function productos()
    {
        return $this->belongsToMany(Producto::class, 'alquiler_producto')->withPivot('cantidad');
    }
}
