<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Venta extends Model
{
    use HasFactory;

    protected $table = 'ventas';

    protected $fillable = [
        'alquiler_id',
        'monto_pagado',
        'vuelto',
        'total',      // nuevo campo para almacenar el total de la venta
        'estado',     // nuevo campo para indicar si está pagada o pendiente
    ];

    /**
     * Una venta tiene muchos productos (detalles)
     */
    public function detalles()
    {
        return $this->hasMany(VentaDetalle::class, 'venta_id');
    }

    /**
     * Relación con el alquiler (si aplica)
     */
    public function alquiler()
    {
        return $this->belongsTo(Alquiler::class);
    }
}
