<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends \Illuminate\Database\Migrations\Migration {
    public function up()
    {
        Schema::table('ventas', function (Blueprint $table) {
            // 🔓 Primero eliminamos la foreign key
            $table->dropForeign(['producto_id']);

            // 🧹 Luego eliminamos la columna
            $table->dropColumn('producto_id');
        });
    }

    public function down()
    {
        Schema::table('ventas', function (Blueprint $table) {
            $table->unsignedBigInteger('producto_id')->nullable();

            $table->foreign('producto_id')->references('id')->on('productos')->onDelete('set null');
        });
    }
};
