<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;  // Importa la clase Permission
use Spatie\Permission\Models\Role;       // Importa la clase Role
use App\Models\User;   
class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Permission::create(['name' => 'ver usuarios']);
        Permission::create(['name' => 'crear usuario']);

        Permission::create(['name' => 'ver peliculas']);
        Permission::create(['name' => 'crear peliculas']);

        $adminUser =  User::query()->create([
            'name' => 'admin',
            'email' => 'admin@admin.com',
            'password' => '12345678',
            'email_verified_at' => now()
        ]);

        $roleAdmin = Role::create(['name' => 'super-admin']);

        $adminUser->assignRole($roleAdmin);
        $permissionsAdmin = Permission::query()->pluck('name');
        $roleAdmin->syncPermissions($permissionsAdmin);

        $personalUser =  User::query()->create([
            'name' => 'personal',
            'email' => 'personal@admin.com',
            'password' => '12345678',
            'email_verified_at' => now()
        ]);

        $rolepersonal = Role::create(['name' =>'personal']);
        $personalUser->assignRole($rolepersonal);
        $rolepersonal->syncPermissions(['ver peliculas']);




    }
}
