<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ticket de Cine Winder</title>
    <style>
        body {
            font-family: "Courier New", monospace;
            font-size: 14px;
            width: 80mm;
            margin: 0 auto;
            padding: 2mm;
            background: white;
        }

        .ticket {
            width: 100%;
            max-width: 80mm;
            padding: 0;
        }

        .titulo {
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 3px;
            text-align: center;
            text-transform: uppercase;
        }

        .separador {
            border-top: 1px dashed #000;
            margin: 5px 0;
        }

        .info {
            margin: 3px 0;
            line-height: 1.3;
        }

        .resaltado {
            font-weight: bold;
        }

        .qr-container {
            margin: 10px 0;
            text-align: center;
        }

        .qr-code {
            width: 60px;
            height: 60px;
            margin-bottom: 5px;
        }

        .agradecimiento {
            font-size: 13px;
            margin-top: 10px;
            text-align: center;
            font-style: italic;
        }

        .text-center {
            text-align: center;
        }

        .text-small {
            font-size: 12px;
        }
    </style>
</head>
<body>
    <div class="ticket">
        <div class="titulo">Cine Winder</div>
        <div class="separador"></div>
        
        <p class="info"><span class="resaltado">Ticket #:</span> {{ $alquiler->id }}</p>
        <p class="info"><span class="resaltado">Fecha:</span> {{ now()->format('d/m/Y H:i') }}</p>
        
        @php
            // Procesamiento de nombre del cliente
            $nombreCompleto = explode(' ', trim($alquiler->cliente));
            $nombres = implode(' ', array_slice($nombreCompleto, 0, 2));
            $apellidos = implode(' ', array_slice($nombreCompleto, 2));
            $inicialNombre = $nombreCompleto[0][0] ?? '';
            $inicialApellido = $nombreCompleto[1][0] ?? $nombreCompleto[0][0] ?? '';
            
            // Datos para el QR
            $qrData = "CINE WINDER\n";
            $qrData .= "Ticket: #".$alquiler->id."\n";
            $qrData .= "Película: ".($alquiler->pelicula->titulo ?? 'N/A')."\n";
            $qrData .= "Sala: ".($alquiler->sala->nombre ?? 'N/A')."\n";
            $qrData .= "Horario: ".date('H:i', strtotime($alquiler->hora_entrada))." - ".date('H:i', strtotime($alquiler->hora_salida))."\n";
            $qrData .= "Cliente: ".$nombres." ".$apellidos."\n";
            $qrData .= "Precio: S/ ".number_format($alquiler->precio, 2);
        @endphp

        <div class="separador"></div>
        
        <p class="info"><span class="resaltado">Cliente:</span> {{ $nombres }}</p>
        <p class="info"><span class="resaltado">Apellidos:</span> {{ $apellidos }}</p>
        
        <div class="separador"></div>
        
        <p class="info"><span class="resaltado">Película:</span> {{ $alquiler->pelicula->titulo ?? 'N/A' }}</p>
        <p class="info"><span class="resaltado">Sala:</span> {{ $alquiler->sala->nombre ?? 'N/A' }}</p>
        <p class="info"><span class="resaltado">Horario:</span> {{ date('H:i', strtotime($alquiler->hora_entrada)) }} - {{ date('H:i', strtotime($alquiler->hora_salida)) }}</p>
        <p class="info"><span class="resaltado">Duración:</span> {{ $alquiler->pelicula->duracion ?? 'N/A' }} min</p>
        <p class="info"><span class="resaltado">Asientos:</span> {{ $alquiler->asientos ?? 'General' }}</p>
        
        <div class="separador"></div>
        
        <p class="info"><span class="resaltado">Método de pago:</span> {{ ucfirst($alquiler->metodo_pago ?? 'Efectivo') }}</p>
        <p class="info"><span class="resaltado">Precio:</span> S/ {{ number_format($alquiler->precio, 2) }}</p>
        <p class="info"><span class="resaltado">Código:</span> CE-{{ strtoupper($inicialNombre) }}{{ strtoupper($inicialApellido) }}-{{ $alquiler->id }}</p>
        <p class="info"><span class="resaltado">Atendido por:</span> {{ $alquiler->empleado ?? 'Elvis' }}</p>
        
        <div class="separador"></div>

        <!-- Código QR -->
        <div class="qr-container">
            <img src="https://api.qrserver.com/v1/create-qr-code/?size=150x150&data={{ urlencode($qrData) }}" 
                 alt="Código QR de validación" class="qr-code">
            <p class="text-small">Escanea para validar tu entrada</p>
        </div>
        
        <div class="separador"></div>
        
        <p class="agradecimiento">¡Gracias por preferirnos!<br>Disfruta de la función</p>
    </div>
</body>
</html>