<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Ticket</title>
    <style>
        body {
            font-family: monospace;
            font-size: 12px;
            padding: 10px;
        }
        h2, h4 {
            text-align: center;
            margin: 0;
        }
        .line {
            border-top: 1px dashed #000;
            margin: 5px 0;
        }
        .center {
            text-align: center;
        }
        .qr {
            display: flex;
            justify-content: flex-start;
            margin-top: 10px;
            margin-bottom: 10px;
        }
        .qr img {
            width: 80px;
            height: 80px;
            margin-left: 55px; /* Empuja a la derecha visualmente */
        }
    </style>
</head>
<body>
    @php
        // Iniciales del cliente para el código
        $cliente = strtoupper($alquiler->cliente);
        $partes = explode(' ', $cliente);
        $inicialNombre = $partes[0][0] ?? 'X';
        $inicialApellido = $partes[1][0] ?? $partes[0][1] ?? 'X';

        // Código personalizado
        $codigo = "CINEMA-{$inicialNombre}{$inicialApellido}-{$alquiler->id}";
    @endphp

    <h2>CINESTACION</h2>
    <div class="line"></div>
    <p><strong>N° Ticket:</strong> {{ $alquiler->id }}</p>
    <p><strong>Fecha:</strong> {{ now()->format('d/m/Y H:i') }}</p>
    <p><strong>Cliente:</strong> {{ $alquiler->cliente }}</p>
    <p><strong>Película:</strong> {{ $alquiler->pelicula->titulo }}</p>
    <p><strong>Sala:</strong> 
    @if ($alquiler->sala)
        {{ strtoupper($alquiler->sala->tipo) }} - {{ $alquiler->sala->nombre }}
    @else
        ---
    @endif
</p>
    <p><strong>Entrada:</strong> {{ $alquiler->hora_entrada }}</p>
    <p><strong>Salida:</strong> {{ $alquiler->hora_salida }}</p>
    <p><strong>Precio:</strong> S/ {{ number_format($alquiler->precio, 2) }}</p>
    <p><strong>Estado:</strong> {{ ucfirst($alquiler->estado) }}</p>
    <p><strong>Método de pago:</strong> {{ ucfirst($alquiler->metodo_pago ?? '---') }}</p>



    <p><strong>Código:</strong> {{ $codigo }}</p>

    <div class="line"></div>

    <!-- QR incluido -->
    <div class="qr">
        <img src="{{ $qrSrc }}" alt="Código QR">
    </div>
    <p class="center">Escanea para validar</p>

    <div class="line"></div>
    <p class="center">¡Gracias por su visita!</p>
</body>
</html>
