@extends('adminlte::page')

@section('title', 'Editar Usuario')

@section('content_header')
<div class="d-flex justify-content-between align-items-center">
    <h1 class="m-0 text-primary font-weight-bold"><i class="fas fa-user-edit mr-2"></i>Editar Usuario</h1>
    <a href="{{ route('usuarios.index') }}" class="btn btn-outline-primary btn-sm rounded-pill px-3 hover-animate">
        <i class="fas fa-arrow-left mr-1"></i> Volver
    </a>
</div>
@stop

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-lg-7">
            <div class="card card-glass">
                <div class="card-header bg-gradient-modern p-0">
                   
                </div>
                <form action="{{ route('usuarios.update', $usuario->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    
                    <div class="card-body py-4">
                        <!-- Foto de Perfil -->
                        <div class="form-group text-center mb-4 profile-section">
                            <div class="profile-image-container">
                                @if($usuario->foto)
                                    <img id="profileImagePreview" src="{{ asset('storage/' . $usuario->foto) }}" 
                                         class="profile-img" alt="Foto de perfil">
                                @else
                                    <div id="profileImagePreview" class="profile-img-placeholder">
                                        <i class="fas fa-user"></i>
                                    </div>
                                @endif
                                <div class="profile-actions">
                                    <label for="foto" class="btn-edit-photo" title="Cambiar foto">
                                        <i class="fas fa-camera"></i>
                                    </label>
                                    <button type="button" id="removePhotoBtn" 
                                            class="btn-remove-photo {{ $usuario->foto ? '' : 'd-none' }}" 
                                            onclick="removeProfileImage()" title="Eliminar foto">
                                        <i class="fas fa-trash-alt"></i>
                                    </button>
                                </div>
                                <input type="file" name="foto" id="foto" class="d-none" accept="image/*">
                            </div>
                            <div class="profile-name mt-2">{{ $usuario->name }}</div>
                            <div class="profile-email">{{ $usuario->email }}</div>
                            <span class="profile-help">Formatos: JPG, PNG (Max. 2MB)</span>
                        </div>

                        <div class="form-card">
                            <!-- Campos del formulario -->
                            <div class="form-group floating-group">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-user"></i>
                                        </span>
                                    </div>
                                    <input type="text" name="name" id="name" 
                                           class="form-control @error('name') is-invalid @enderror" 
                                           value="{{ old('name', $usuario->name) }}" required>
                                    <label for="name">Nombre Completo</label>
                                </div>
                                @error('name')
                                    <div class="invalid-feedback">
                                        <i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <div class="form-group floating-group">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-envelope"></i>
                                        </span>
                                    </div>
                                    <input type="email" name="email" id="email" 
                                           class="form-control @error('email') is-invalid @enderror" 
                                           value="{{ old('email', $usuario->email) }}" required>
                                    <label for="email">Correo Electrónico</label>
                                </div>
                                @error('email')
                                    <div class="invalid-feedback">
                                        <i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <div class="password-section">
                                <h6 class="section-title">Actualizar Contraseña</h6>
                                
                                <div class="form-group floating-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">
                                                <i class="fas fa-lock"></i>
                                            </span>
                                        </div>
                                        <input type="password" name="password" id="password" 
                                               class="form-control @error('password') is-invalid @enderror">
                                        <label for="password">Nueva Contraseña</label>
                                        <div class="input-group-append">
                                            <button class="btn-password-toggle toggle-password" type="button">
                                                <i class="fas fa-eye"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <!-- Barra de fortaleza de contraseña -->
                                    <div class="password-strength-meter">
                                        <div class="password-strength-meter-bar" id="password-strength-bar"></div>
                                    </div>
                                    <div class="password-strength-text" id="password-strength-text"></div>
                                    @error('password')
                                        <div class="invalid-feedback">
                                            <i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}
                                        </div>
                                    @enderror
                                    <small class="password-hint">La contraseña debe contener:</small>
                                    <ul class="password-rules list-unstyled" style="font-size: 0.75rem;">
                                        <li class="text-muted" id="rule-length"><i class="fas fa-circle mr-1" style="font-size: 0.4rem;"></i> Mínimo 8 caracteres</li>
                                        <li class="text-muted" id="rule-uppercase"><i class="fas fa-circle mr-1" style="font-size: 0.4rem;"></i> Al menos una mayúscula</li>
                                        <li class="text-muted" id="rule-number"><i class="fas fa-circle mr-1" style="font-size: 0.4rem;"></i> Al menos un número</li>
                                        <li class="text-muted" id="rule-special"><i class="fas fa-circle mr-1" style="font-size: 0.4rem;"></i> Al menos un carácter especial</li>
                                    </ul>
                                </div>

                                <div class="form-group floating-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">
                                                <i class="fas fa-lock"></i>
                                            </span>
                                        </div>
                                        <input type="password" name="password_confirmation" id="password_confirmation" 
                                               class="form-control">
                                        <label for="password_confirmation">Confirmar Contraseña</label>
                                        <div class="input-group-append">
                                            <button class="btn-password-toggle toggle-password" type="button">
                                                <i class="fas fa-eye"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer">
                        <div class="action-buttons">
                            <button type="reset" class="btn btn-light btn-reset">
                                <i class="fas fa-undo-alt mr-1"></i> Restablecer
                            </button>
                            <button type="submit" class="btn btn-primary btn-save">
                                <i class="fas fa-save mr-1"></i> Guardar Cambios
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@stop

@section('css')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
    :root {
        --primary-color: #4361ee;
        --primary-light: #4895ef;
        --primary-dark: #3f37c9;
        --secondary-color: #4cc9f0;
        --light-color: #f8f9fa;
        --dark-color: #212529;
        --success-color: #31c48d;
        --danger-color: #e74c3c;
        --warning-color: #f59e0b;
        --card-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        --button-shadow: 0 4px 10px rgba(67, 97, 238, 0.3);
        --transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
    }

    /* General Styles */
    body {
        background-color: #f5f7fb;
    }
    
    h1 {
        font-size: 1.8rem;
        letter-spacing: -0.5px;
    }
    
    .text-primary {
        color: var(--primary-color) !important;
    }
    
    /* Card Styles */
    .card-glass {
        background: rgba(255, 255, 255, 0.95);
        border: none;
        border-radius: 15px;
        box-shadow: var(--card-shadow);
        backdrop-filter: blur(5px);
        overflow: hidden;
        transition: var(--transition);
    }
    
    .bg-gradient-modern {
        background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
        position: relative;
        overflow: hidden;
    }
    
    .bg-gradient-modern:before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='100' height='100' viewBox='0 0 100 100'%3E%3Cpath d='M0 0L50 50L0 100' fill='rgba(255,255,255,0.05)'/%3E%3Cpath d='M50 0L100 50L50 100' fill='rgba(255,255,255,0.05)'/%3E%3C/svg%3E");
        opacity: 0.3;
    }
    
    /* Profile Section */
    .profile-section {
        position: relative;
    }
    
    .profile-image-container {
        position: relative;
        width: 140px;
        height: 140px;
        margin: 0 auto;
    }
    
    .profile-img, .profile-img-placeholder {
        width: 140px;
        height: 140px;
        border-radius: 50%;
        border: 4px solid white;
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
        transition: var(--transition);
    }
    
    .profile-img {
        object-fit: cover;
    }
    
    .profile-img-placeholder {
        background: linear-gradient(135deg, #f5f7fa 0%, #e4e8f0 100%);
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .profile-img-placeholder i {
        font-size: 3.5rem;
        color: #b0bec5;
    }
    
    .profile-img:hover, .profile-img-placeholder:hover {
        transform: scale(1.05);
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
    }
    
    .profile-actions {
        position: absolute;
        bottom: 10px;
        right: 0;
        display: flex;
        gap: 8px;
    }
    
    .btn-edit-photo, .btn-remove-photo {
        width: 32px;
        height: 32px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        transition: var(--transition);
        box-shadow: 0 3px 10px rgba(0, 0, 0, 0.1);
        border: none;
    }
    
    .btn-edit-photo {
        background: var(--primary-color);
        color: white;
    }
    
    .btn-remove-photo {
        background: var(--danger-color);
        color: white;
    }
    
    .btn-edit-photo:hover, .btn-remove-photo:hover {
        transform: translateY(-3px);
    }
    
    .profile-name {
        font-weight: 600;
        font-size: 1.2rem;
        color: var(--dark-color);
        margin-top: 12px;
    }
    
    .profile-email {
        color: #6c757d;
        font-size: 0.9rem;
        margin-bottom: 5px;
    }
    
    .profile-help {
        display: inline-block;
        font-size: 0.75rem;
        color: #8e9aaf;
        background: #f1f4f9;
        padding: 3px 8px;
        border-radius: 12px;
        margin-top: 5px;
    }
    
    /* Form Card */
    .form-card {
        background: white;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.03);
        margin-bottom: 15px;
    }
    
    /* Floating Label Input Groups */
    .floating-group {
        position: relative;
        margin-bottom: 25px;
    }
    
    .floating-group .input-group {
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 3px 10px rgba(0, 0, 0, 0.03);
        transition: var(--transition);
    }
    
    .floating-group .input-group:focus-within {
        box-shadow: 0 5px 15px rgba(67, 97, 238, 0.1);
    }
    
    .floating-group .input-group-text {
        background-color: white;
        border: 1px solid #e9ecef;
        border-right: none;
        color: var(--primary-color);
        border-radius: 12px 0 0 12px !important;
        padding: 0.65rem 1rem;
    }
    
    .floating-group .form-control {
        border: 1px solid #e9ecef;
        border-left: none;
        border-radius: 0 12px 12px 0 !important;
        height: auto;
        padding: 0.65rem 1rem;
        font-size: 0.95rem;
    }
    
    .floating-group label {
        position: absolute;
        top: 50%;
        left: 3.5rem;
        transform: translateY(-50%);
        transition: var(--transition);
        margin: 0;
        font-size: 0.95rem;
        color: #6c757d;
        pointer-events: none;
        z-index: 10;
    }
    
    .floating-group .form-control:focus,
    .floating-group .form-control:not(:placeholder-shown) {
        padding-top: 1.1rem;
        padding-bottom: 0.3rem;
    }
    
    .floating-group .form-control:focus + label,
    .floating-group .form-control:not(:placeholder-shown) + label {
        transform: translateY(-130%);
        font-size: 0.75rem;
        color: var(--primary-color);
        font-weight: 600;
    }
    
    .floating-group .form-control::placeholder {
        color: transparent;
    }
    
    .btn-password-toggle {
        background: transparent;
        border: none;
        color: #6c757d;
        cursor: pointer;
        padding: 0.65rem 1rem;
        font-size: 0.85rem;
        transition: var(--transition);
    }
    
    .btn-password-toggle:hover {
        color: var(--primary-color);
    }
    
    .password-hint {
        display: block;
        margin-top: 5px;
        font-size: 0.75rem;
        color: #8e9aaf;
    }
    
    /* Password Section */
    .password-section {
        background: #f8f9fb;
        border-radius: 10px;
        padding: 18px;
        margin-top: 15px;
    }
    
    .section-title {
        font-size: 0.85rem;
        font-weight: 600;
        color: var(--dark-color);
        margin-bottom: 15px;
        position: relative;
        padding-left: 15px;
    }
    
    .section-title:before {
        content: '';
        position: absolute;
        left: 0;
        top: 0;
        height: 100%;
        width: 4px;
        background: var(--primary-color);
        border-radius: 2px;
    }

    /* Password Strength Meter */
    .password-strength-meter {
        height: 5px;
        width: 100%;
        background-color: #e9ecef;
        border-radius: 3px;
        margin-top: 8px;
        overflow: hidden;
    }

    .password-strength-meter-bar {
        height: 100%;
        width: 0;
        transition: width 0.3s ease, background-color 0.3s ease;
    }

    .password-strength-text {
        font-size: 0.75rem;
        margin-top: 5px;
        text-align: right;
        font-weight: 500;
    }

    /* Strength levels colors */
    .password-weak {
        background-color: #e74c3c; /* Rojo */
        width: 25%;
    }

    .password-medium {
        background-color: #f39c12; /* Naranja */
        width: 50%;
    }

    .password-strong {
        background-color: #2ecc71; /* Verde */
        width: 75%;
    }

    .password-very-strong {
        background-color: #27ae60; /* Verde oscuro */
        width: 100%;
    }

    /* Password Rules */
    .password-rules {
        margin-top: 8px;
    }

    .password-rules li {
        margin-bottom: 4px;
    }

    .password-rules .text-success {
        color: var(--success-color) !important;
    }
    
    /* Card Footer */
    .card-footer {
        background: #f8f9fb;
        border-top: 1px solid rgba(0, 0, 0, 0.05);
        padding: 20px;
    }
    
    .action-buttons {
        display: flex;
        justify-content: flex-end;
        gap: 12px;
    }
    
    .btn {
        border-radius: 10px;
        padding: 0.5rem 1.5rem;
        font-size: 0.9rem;
        font-weight: 500;
        transition: var(--transition);
    }
    
    .btn-primary {
        background: var(--primary-color);
        border-color: var(--primary-color);
        box-shadow: var(--button-shadow);
    }
    
    .btn-primary:hover {
        background: var(--primary-dark);
        border-color: var(--primary-dark);
        transform: translateY(-2px);
        box-shadow: 0 6px 15px rgba(67, 97, 238, 0.4);
    }
    
    .btn-light {
        background: white;
        border-color: #e9ecef;
        color: #6c757d;
    }
    
    .btn-light:hover {
        background: #f8f9fa;
        transform: translateY(-2px);
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.05);
    }
    
    .btn i {
        font-size: 0.85rem;
    }
    
    /* Error Styles */
    .invalid-feedback {
        font-size: 0.75rem;
        padding-left: 0.5rem;
        margin-top: 0.25rem;
    }
    
    .is-invalid {
        border-color: var(--danger-color) !important;
    }
    
    /* Animations */
    .hover-animate {
        transition: var(--transition);
    }
    
    .hover-animate:hover {
        transform: translateY(-2px);
    }
    
    /* Responsive Adjustments */
    @media (max-width: 767px) {
        .col-lg-7 {
            padding-left: 10px;
            padding-right: 10px;
        }
        
        .card-body {
            padding: 1.25rem;
        }
        
        .action-buttons {
            flex-direction: column;
            gap: 10px;
        }
        
        .btn {
            width: 100%;
        }
    }
</style>
@stop

@section('js')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    // Añadir placeholder vacío necesario para los floating labels
    document.addEventListener('DOMContentLoaded', function() {
        const inputs = document.querySelectorAll('.floating-group .form-control');
        inputs.forEach(input => {
            input.setAttribute('placeholder', ' ');
        });
    });

    // Vista previa de la imagen seleccionada
    document.getElementById('foto').addEventListener('change', function(event) {
        const preview = document.getElementById('profileImagePreview');
        const file = event.target.files[0];
        const reader = new FileReader();
        
        reader.onload = function(e) {
            if (preview.tagName === 'IMG') {
                preview.src = e.target.result;
            } else {
                // Si es el div, lo reemplazamos por una imagen
                const newPreview = document.createElement('img');
                newPreview.id = 'profileImagePreview';
                newPreview.src = e.target.result;
                newPreview.className = 'profile-img';
                newPreview.alt = 'Foto de perfil';
                preview.parentNode.replaceChild(newPreview, preview);
            }
            document.getElementById('removePhotoBtn').classList.remove('d-none');
        }
        
        if (file) {
            // Validar tamaño máximo (2MB)
            if (file.size > 2 * 1024 * 1024) {
                Swal.fire({
                    icon: 'error',
                    title: 'Archivo demasiado grande',
                    text: 'La imagen no debe exceder los 2MB',
                    confirmButtonColor: '#4361ee',
                    customClass: {
                        popup: 'swal-small'
                    }
                });
                this.value = '';
                return;
            }
            reader.readAsDataURL(file);
        }
    });

    // Eliminar foto de perfil
    function removeProfileImage() {
        const previewContainer = document.getElementById('profileImagePreview').parentNode;
        const newPreview = document.createElement('div');
        newPreview.id = 'profileImagePreview';
        newPreview.className = 'profile-img-placeholder';
        
        const icon = document.createElement('i');
        icon.className = 'fas fa-user';
        
        newPreview.appendChild(icon);
        previewContainer.replaceChild(newPreview, document.getElementById('profileImagePreview'));
        
        document.getElementById('foto').value = '';
        document.getElementById('removePhotoBtn').classList.add('d-none');
    }

    // Mostrar/ocultar contraseña
    document.querySelectorAll('.toggle-password').forEach(button => {
        button.addEventListener('click', function() {
            const input = this.closest('.input-group').querySelector('input');
            const icon = this.querySelector('i');
            
            if (input.type === 'password') {
                input.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                input.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        });
    });

    // Verificador de fortaleza de contraseña
    document.getElementById('password').addEventListener('input', function() {
        const password = this.value;
        const strengthBar = document.getElementById('password-strength-bar');
        const strengthText = document.getElementById('password-strength-text');
        
        // Reset classes
        strengthBar.className = 'password-strength-meter-bar';
        
        if (password.length === 0) {
            strengthBar.style.width = '0';
            strengthText.textContent = '';
            return;
        }
        
        // Calcular fortaleza
        let strength = 0;
        
        // Longitud mínima
        if (password.length >= 8) strength += 1;
        
        // Contiene letras minúsculas
        if (/[a-z]/.test(password)) strength += 1;
        
        // Contiene letras mayúsculas
        if (/[A-Z]/.test(password)) strength += 1;
        
        // Contiene números
        if (/[0-9]/.test(password)) strength += 1;
        
        // Contiene caracteres especiales
        if (/[^a-zA-Z0-9]/.test(password)) strength += 1;
        
        // Determinar nivel de fortaleza
        let strengthLevel = '';
        let strengthClass = '';
        
        if (password.length < 8) {
            strengthLevel = 'Muy débil';
            strengthClass = 'password-weak';
        } else if (strength <= 2) {
            strengthLevel = 'Débil';
            strengthClass = 'password-weak';
        } else if (strength === 3) {
            strengthLevel = 'Moderada';
            strengthClass = 'password-medium';
        } else if (strength === 4) {
            strengthLevel = 'Fuerte';
            strengthClass = 'password-strong';
        } else {
            strengthLevel = 'Muy fuerte';
            strengthClass = 'password-very-strong';
        }
        
        // Aplicar cambios visuales
        strengthBar.classList.add(strengthClass);
        strengthText.textContent = strengthLevel;
        strengthText.style.color = getComputedStyle(strengthBar).backgroundColor;
    });

    // Verificación de reglas de contraseña
    document.getElementById('password').addEventListener('input', function() {
        const password = this.value;
        
        // Regla de longitud
        document.getElementById('rule-length').className = password.length >= 8 ? 'text-success' : 'text-muted';
        
        // Regla de mayúsculas
        document.getElementById('rule-uppercase').className = /[A-Z]/.test(password) ? 'text-success' : 'text-muted';
        
        // Regla de números
        document.getElementById('rule-number').className = /[0-9]/.test(password) ? 'text-success' : 'text-muted';
        
        // Regla de caracteres especiales
        document.getElementById('rule-special').className = /[^a-zA-Z0-9]/.test(password) ? 'text-success' : 'text-muted';
    });

    // Efecto al hacer clic en el botón de guardar
    document.querySelector('.btn-save').addEventListener('click', function() {
        const button = this;
        button.classList.add('clicked');
        setTimeout(() => {
            button.classList.remove('clicked');
        }, 300);
    });
</script>
@stop