@extends('adminlte::page')

@section('title', 'Registrar Nuevo Usuario')

@section('content')
@can('crear peliculas')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card border-0 shadow-xl rounded-lg overflow-hidden">
                <!-- Header con diseño de ondas -->
                <div class="card-header position-relative p-0">
                    <div class="bg-gradient-primary text-white py-4 px-4">
                        <div class="d-flex justify-content-between align-items-center position-relative z-10">
                            <h3 class="mb-0 font-weight-bold">
                                <i class="fas fa-user-plus mr-2"></i>Registrar Nuevo Usuario
                            </h3>
                            <a href="{{ route('usuarios.index') }}" class="btn btn-light btn-sm rounded-pill px-3">
                                <i class="fas fa-arrow-left mr-1"></i> Volver
                            </a>
                        </div>
                    </div>
                    <!-- Elemento decorativo de ondas -->
                    
                </div>
                
                <div class="card-body p-4">
                    <form method="POST" action="{{ route('register') }}" enctype="multipart/form-data" class="needs-validation" novalidate>
                        @csrf
                        
                        @if ($errors->any())
                            <div class="alert alert-danger alert-dismissible fade show border-0 shadow-sm">
                                <button type="button" class="close" data-dismiss="alert">&times;</button>
                                <h5 class="alert-heading mb-2"><i class="fas fa-exclamation-triangle mr-2"></i>Por favor corrige los siguientes errores:</h5>
                                <ul class="mb-0 pl-3">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <!-- Foto de Perfil -->
                        <div class="text-center mb-5 position-relative">
                            <div class="profile-upload-container mx-auto">
                                <div id="profileImagePreview" class="profile-image mx-auto">
                                    <i class="fas fa-user profile-placeholder"></i>
                                    <div class="profile-overlay">
                                        <i class="fas fa-camera"></i>
                                        <div class="profile-text">Subir foto</div>
                                    </div>
                                </div>
                                <input type="file" id="foto" name="foto" accept="image/*" class="d-none" onchange="previewProfileImage(this)">
                            </div>
                            <small class="text-muted mt-2 d-block">Haz clic para seleccionar una foto (JPG, PNG - Máx. 2MB)</small>
                            
                            <!-- Progress bar para carga de imagen -->
                            <div class="progress upload-progress d-none mt-3 mx-auto" style="height: 6px; max-width: 250px;">
                                <div class="progress-bar progress-bar-striped progress-bar-animated bg-primary" role="progressbar" style="width: 0%"></div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- Columna izquierda -->
                            <div class="col-md-6 pr-md-4">
                                <!-- Nombre -->
                                <div class="form-group mb-4">
                                    <label for="name" class="form-label font-weight-bold text-muted">
                                        <i class="fas fa-user-edit text-primary mr-2"></i>Nombre Completo
                                    </label>
                                    <div class="input-group input-group-merge shadow-sm">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text border-0 bg-light"><i class="fas fa-user text-primary"></i></span>
                                        </div>
                                        <input type="text" id="name" name="name" class="form-control border-0 pl-0" 
                                            value="{{ old('name') }}" required autofocus
                                            placeholder="Ingrese el nombre completo">
                                        <div class="invalid-feedback">Por favor, ingrese un nombre válido.</div>
                                    </div>
                                </div>

                                <!-- Email -->
                                <div class="form-group mb-4">
                                    <label for="email" class="form-label font-weight-bold text-muted">
                                        <i class="fas fa-envelope text-primary mr-2"></i>Correo Electrónico
                                    </label>
                                    <div class="input-group input-group-merge shadow-sm">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text border-0 bg-light"><i class="fas fa-at text-primary"></i></span>
                                        </div>
                                        <input type="email" id="email" name="email" class="form-control border-0 pl-0" 
                                            value="{{ old('email') }}" required
                                            placeholder="nombre@ejemplo.com">
                                        <div class="invalid-feedback">Por favor, ingrese un email válido.</div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Columna derecha -->
                            <div class="col-md-6 pl-md-4">
                                <!-- Contraseña -->
                                <div class="form-group mb-4">
                                    <label for="password" class="form-label font-weight-bold text-muted">
                                        <i class="fas fa-lock text-primary mr-2"></i>Contraseña
                                    </label>
                                    <div class="input-group input-group-merge shadow-sm">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text border-0 bg-light"><i class="fas fa-key text-primary"></i></span>
                                        </div>
                                        <input type="password" id="password" name="password" class="form-control border-0 pl-0" 
                                            required placeholder="Mínimo 8 caracteres">
                                        <div class="input-group-append">
                                            <button class="btn btn-light border-0 toggle-password" type="button" data-toggle="tooltip" title="Mostrar contraseña">
                                                <i class="fas fa-eye text-muted"></i>
                                            </button>
                                        </div>
                                        <div class="invalid-feedback">La contraseña debe tener al menos 8 caracteres.</div>
                                    </div>
                                    <div class="password-strength mt-2 d-none">
                                        <div class="progress" style="height: 5px;">
                                            <div class="progress-bar bg-danger" role="progressbar" style="width: 0%"></div>
                                        </div>
                                        <small class="text-muted d-block mt-1">Seguridad de la contraseña: <span class="strength-text">Débil</span></small>
                                    </div>
                                </div>

                                <!-- Confirmar Contraseña -->
                                <div class="form-group mb-4">
                                    <label for="password_confirmation" class="form-label font-weight-bold text-muted">
                                        <i class="fas fa-lock text-primary mr-2"></i>Confirmar Contraseña
                                    </label>
                                    <div class="input-group input-group-merge shadow-sm">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text border-0 bg-light"><i class="fas fa-key text-primary"></i></span>
                                        </div>
                                        <input type="password" id="password_confirmation" name="password_confirmation" 
                                            class="form-control border-0 pl-0" required placeholder="Repita la contraseña">
                                        <div class="input-group-append">
                                            <button class="btn btn-light border-0 toggle-password" type="button" data-toggle="tooltip" title="Mostrar contraseña">
                                                <i class="fas fa-eye text-muted"></i>
                                            </button>
                                        </div>
                                        <div class="invalid-feedback">Las contraseñas no coinciden.</div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Selección de Rol con elementos visuales -->
                        <div class="form-group mb-5 mt-4">
                            <label class="form-label font-weight-bold text-muted mb-3">
                                <i class="fas fa-user-shield text-primary mr-2"></i>Seleccione el Rol de Usuario
                            </label>
                            <div class="row">
                                <div class="col-md-6 mb-3 mb-md-0">
                                    <div class="role-card shadow-sm" data-role="super-admin">
                                        <input type="radio" name="role" id="role-super-admin" value="super-admin" class="role-input" {{ old('role') == 'super-admin' ? 'checked' : '' }}>
                                        <label for="role-super-admin" class="role-label">
                                            <div class="role-icon bg-primary text-white">
                                                <i class="fas fa-crown"></i>
                                            </div>
                                            <div class="role-details">
                                                <h5 class="role-title">Super Admin</h5>
                                                <p class="role-description">Control total del sistema y acceso a todas las funciones</p>
                                            </div>
                                            <div class="role-check">
                                                <i class="fas fa-check-circle"></i>
                                            </div>
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="role-card shadow-sm" data-role="personal">
                                        <input type="radio" name="role" id="role-personal" value="personal" class="role-input" {{ old('role') == 'personal' ? 'checked' : '' }}>
                                        <label for="role-personal" class="role-label">
                                            <div class="role-icon bg-info text-white">
                                                <i class="fas fa-user-tie"></i>
                                            </div>
                                            <div class="role-details">
                                                <h5 class="role-title">Personal</h5>
                                                <p class="role-description">Acceso limitado a funciones específicas del sistema</p>
                                            </div>
                                            <div class="role-check">
                                                <i class="fas fa-check-circle"></i>
                                            </div>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Botón de envío con animación -->
                        <div class="form-group text-center mt-5">
                            <button type="submit" class="btn btn-primary btn-lg px-5 py-2 shadow-sm rounded-pill submit-btn">
                                <span class="btn-text"><i class="fas fa-user-plus mr-2"></i>Registrar Usuario</span>
                                <span class="btn-spinner d-none">
                                    <i class="fas fa-circle-notch fa-spin"></i> Procesando...
                                </span>
                            </button>
                        </div>
                    </form>
                </div>
                
              
            </div>
        </div>
    </div>
</div>
@endcan
@endsection

@section('css')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<style>
    /* Colores principales */
    :root {
        --primary: #4361ee;
        --primary-light: #4895ef;
        --primary-dark: #3f37c9;
        --success: #4cc9f0;
        --info: #4895ef;
        --warning: #fca311;
        --danger: #e71d36;
        --light: #f8f9fa;
        --dark: #212529;
        --gray: #6c757d;
    }
    
    /* Elementos generales */
    .card {
        border-radius: 15px;
        overflow: hidden;
        transition: all 0.3s ease;
    }
    
    .form-control {
        font-size: 1rem;
        padding: 0.75rem 1rem;
        transition: all 0.2s ease;
    }
    
    .form-control:focus {
        box-shadow: none;
        border-color: var(--primary);
    }
    
    .input-group-merge .input-group-text {
        font-size: 1rem;
        padding-left: 1.25rem;
        padding-right: 1rem;
    }
    
    .input-group-merge .form-control {
        padding-left: 0.5rem;
    }
    
    /* Estilos del header con ondas */
    .bg-gradient-primary {
        background: linear-gradient(45deg, var(--primary-dark), var(--primary-light));
    }
    
    .wave-container {
        position: absolute;
        bottom: -2px;
        left: 0;
        width: 100%;
        height: 50px;
        overflow: hidden;
        line-height: 0;
    }
    
    .waves {
        width: 100%;
        height: 100%;
    }
    
    .wave-1, .wave-2, .wave-3 {
        fill: #fff;
    }
    
    /* Perfil de usuario upload */
    .profile-upload-container {
        position: relative;
        width: 150px;
        height: 150px;
        cursor: pointer;
    }
    
    .profile-image {
        width: 150px;
        height: 150px;
        border-radius: 50%;
        background-color: #f0f7ff;
        border: 4px solid #e6effd;
        overflow: hidden;
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
        transition: all 0.3s ease;
        cursor: pointer;
        box-shadow: 0 5px 15px rgba(67, 97, 238, 0.15);
    }
    
    .profile-image:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 25px rgba(67, 97, 238, 0.25);
        border-color: var(--primary-light);
    }
    
    .profile-placeholder {
        font-size: 5rem;
        color: #c1d3fe;
    }
    
    .profile-overlay {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(67, 97, 238, 0.7);
        color: white;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        opacity: 0;
        transition: opacity 0.3s ease;
        border-radius: 50%;
    }
    
    .profile-image:hover .profile-overlay {
        opacity: 1;
    }
    
    .profile-overlay i {
        font-size: 2rem;
        margin-bottom: 0.5rem;
    }
    
    .profile-text {
        font-size: 0.9rem;
        font-weight: 500;
    }
    
    /* Selección de roles */
    .role-card {
        border-radius: 10px;
        overflow: hidden;
        position: relative;
        transition: all 0.3s ease;
        cursor: pointer;
        margin-bottom: 1rem;
        border: 1px solid #e6effd;
        height: 100%;
    }
    
    .role-input {
        position: absolute;
        opacity: 0;
        z-index: -1;
    }
    
    .role-label {
        display: flex;
        align-items: center;
        padding: 15px;
        margin: 0;
        width: 100%;
        height: 100%;
        cursor: pointer;
    }
    
    .role-icon {
        width: 50px;
        height: 50px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 15px;
        transition: all 0.3s ease;
    }
    
    .role-icon i {
        font-size: 1.5rem;
    }
    
    .role-details {
        flex: 1;
    }
    
    .role-title {
        font-size: 1.1rem;
        margin-bottom: 5px;
        font-weight: 600;
        color: var(--dark);
    }
    
    .role-description {
        font-size: 0.85rem;
        color: var(--gray);
        margin-bottom: 0;
    }
    
    .role-check {
        color: transparent;
        margin-left: 10px;
        font-size: 1.2rem;
        transition: all 0.3s ease;
    }
    
    .role-input:checked + .role-label .role-check {
        color: var(--primary);
    }
    
    .role-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    }
    
    .role-input:checked ~ .role-card {
        border-color: var(--primary);
    }
    
    /* Botón de submit con animación */
    .btn-primary {
        background: linear-gradient(45deg, var(--primary), var(--primary-light));
        border: none;
        transition: all 0.3s ease;
    }
    
    .btn-primary:hover {
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(67, 97, 238, 0.3);
        background: linear-gradient(45deg, var(--primary-light), var(--primary));
    }
    
    .submit-btn {
        position: relative;
        overflow: hidden;
    }
    
    .submit-btn:before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
        transition: all 0.6s ease;
    }
    
    .submit-btn:hover:before {
        left: 100%;
    }
    
    /* Alerta de errores con estilo mejorado */
    .alert-danger {
        background-color: #fff8f8;
        color: var(--danger);
        border-left: 4px solid var(--danger);
    }
    
    /* Estilos adaptativos */
    @media (max-width: 768px) {
        .card-body {
            padding: 1.5rem;
        }
        
        .profile-upload-container {
            width: 120px;
            height: 120px;
        }
        
        .profile-image {
            width: 120px;
            height: 120px;
        }
        
        .submit-btn {
            width: 100%;
        }
    }
</style>
@endsection

@section('js')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    $(document).ready(function() {
        // Inicializar tooltips
        $('[data-toggle="tooltip"]').tooltip();
        
        // Efecto para hacer clic en la imagen de perfil
        $('#profileImagePreview').click(function() {
            $('#foto').click();
        });
        
        // Validación de formulario
        const form = document.querySelector('.needs-validation');
        form.addEventListener('submit', function(event) {
            if (form.checkValidity() === false) {
                event.preventDefault();
                event.stopPropagation();
            } else {
                // Animación del botón al enviar
                $('.btn-text').addClass('d-none');
                $('.btn-spinner').removeClass('d-none');
            }
            form.classList.add('was-validated');
        }, false);
        
        // Validar que las contraseñas coincidan
        $('#password_confirmation').on('input', function() {
            const password = $('#password').val();
            const confirmPassword = $(this).val();
            
            if (password !== confirmPassword) {
                $(this).addClass('is-invalid');
            } else {
                $(this).removeClass('is-invalid');
                $(this).addClass('is-valid');
            }
        });
        
        // Medidor de fortaleza de contraseña
        $('#password').on('input', function() {
            const password = $(this).val();
            let strength = 0;
            let color = 'bg-danger';
            let text = 'Débil';
            
            if (password.length >= 8) strength += 1;
            if (password.match(/[a-z]/) && password.match(/[A-Z]/)) strength += 1;
            if (password.match(/\d/)) strength += 1;
            if (password.match(/[^a-zA-Z\d]/)) strength += 1;
            
            if (password.length > 0) {
                $('.password-strength').removeClass('d-none');
                
                if (strength === 1) {
                    color = 'bg-danger';
                    text = 'Débil';
                    width = '25%';
                } else if (strength === 2) {
                    color = 'bg-warning';
                    text = 'Regular';
                    width = '50%';
                } else if (strength === 3) {
                    color = 'bg-info';
                    text = 'Buena';
                    width = '75%';
                } else if (strength === 4) {
                    color = 'bg-success';
                    text = 'Fuerte';
                    width = '100%';
                }
                
                $('.password-strength .progress-bar')
                    .removeClass('bg-danger bg-warning bg-info bg-success')
                    .addClass(color)
                    .css('width', width);
                    
                $('.strength-text').text(text);
            } else {
                $('.password-strength').addClass('d-none');
            }
        });
        
        // Cards de roles
        $('.role-card').click(function() {
            $(this).find('input[type="radio"]').prop('checked', true);
            
            // Animación
            $('.role-card').removeClass('shadow-lg').addClass('shadow-sm');
            $(this).removeClass('shadow-sm').addClass('shadow-lg');
        });
    });

    // Vista previa de la imagen de perfil
    function previewProfileImage(input) {
        const file = input.files[0];
        
        if (file) {
            // Validar tamaño máximo (2MB)
            if (file.size > 2 * 1024 * 1024) {
                Swal.fire({
                    icon: 'error',
                    title: 'Archivo demasiado grande',
                    text: 'La imagen no debe exceder los 2MB',
                    confirmButtonColor: '#4361ee'
                });
                input.value = '';
                return;
            }
            
            // Mostrar barra de progreso
            $('.upload-progress').removeClass('d-none');
            
            // Simulamos una carga
            let progress = 0;
            const interval = setInterval(function() {
                progress += 10;
                $('.upload-progress .progress-bar').css('width', progress + '%');
                
                if (progress >= 100) {
                    clearInterval(interval);
                    setTimeout(() => {
                        $('.upload-progress').addClass('d-none');
                    }, 500);
                }
            }, 100);
            
            const reader = new FileReader();
            reader.onload = function(e) {
                const profileImagePreview = document.getElementById('profileImagePreview');
                
                // Quitar el placeholder y crear elemento de imagen
                profileImagePreview.innerHTML = `
                    <img src="${e.target.result}" class="w-100 h-100" style="object-fit: cover;">
                    <div class="profile-overlay">
                        <i class="fas fa-edit"></i>
                        <div class="profile-text">Cambiar foto</div>
                    </div>
                `;
            };
            reader.readAsDataURL(file);
        }
    }

    // Mostrar/ocultar contraseña
    document.querySelectorAll('.toggle-password').forEach(function(button) {
        button.addEventListener('click', function() {
            const input = this.closest('.input-group').querySelector('input');
            const icon = this.querySelector('i');
            
            if (input.type === 'password') {
                input.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
                this.setAttribute('data-original-title', 'Ocultar contraseña');
            } else {
                input.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
                this.setAttribute('data-original-title', 'Mostrar contraseña');
            }
            
            // Actualizar tooltip
            $(this).tooltip('hide');
            $(this).tooltip('show');
        });
    });
</script>
@endsection