@extends('adminlte::page')

@section('title', 'Acceso Denegado')

@section('content')
<div class="container">
    <div class="row justify-content-center mt-5">
        <div class="col-md-8">
            <div class="card shadow-lg border-0">
                <div class="card-body p-0">
                    <div class="error-page-wrapper position-relative">
                        <!-- Fondo con efecto degradado -->
                        <div class="bg-gradient-success position-absolute w-100 h-100" style="opacity: 0.8; z-index: -1;"></div>

                        
                        <!-- Contenido principal -->
                        <div class="text-center py-5 px-4">
                            <!-- Animación de icono -->
                            <div class="mb-4 animate__animated animate__headShake animate__infinite">
                                <i class="fas fa-lock text-white" style="font-size: 6rem; text-shadow: 0 0 15px rgba(255,255,255,0.6);"></i>
                            </div>
                            
                            <!-- Mensaje principal con efectos -->
                            <h1 class="text-white font-weight-bold mb-3" style="font-size: 3.5rem; text-shadow: 2px 2px 4px rgba(0,0,0,0.5);">ACCESO DENEGADO</h1>
                            
                            <!-- Línea separadora animada -->
                            <div class="separator my-4 mx-auto" style="width: 50%; height: 2px; background: rgba(255,255,255,0.7);"></div>
                            
                            <!-- Mensaje informativo -->
                            <p class="lead text-white mb-4">No tienes los permisos necesarios para acceder a esta sección</p>
                            
                            <!-- Mensaje con contador de redirección -->
                            <p class="text-white mb-4">Serás redirigido automáticamente en <span id="countdown">15</span> segundos</p>
                            
                            <!-- Botones con hover effects -->
                            <div class="mt-5 d-flex justify-content-center flex-wrap">
                                <a href="{{ url()->previous() }}" class="btn btn-light btn-lg m-2 px-4 transition-all">
                                    <i class="fas fa-arrow-left mr-2"></i> Volver atrás
                                </a>
                                <a href="{{ route('dashboard') }}" class="btn btn-light btn-lg m-2 px-4 transition-all">
                                    <i class="fas fa-home mr-2"></i> Ir al inicio
                                </a>
                                <a href="#" id="supportBtn" class="btn btn-warning btn-lg m-2 px-4 transition-all">
                                    <i class="fas fa-headset mr-2"></i> Solicitar acceso
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Tarjeta con información adicional (aparece con animación) -->
            <div id="supportInfo" class="card shadow-lg border-0 mt-4 animate__animated animate__fadeInUp" style="display: none;">
                <div class="card-header bg-warning">
                    <h5 class="mb-0 font-weight-bold"><i class="fas fa-info-circle mr-2"></i> Información de contacto</h5>
                </div>
                <div class="card-body">
                    <p>Si necesitas acceso a esta sección, por favor contacta al administrador del sistema:</p>
                    <ul class="list-unstyled">
                        <li><i class="fas fa-envelope mr-2 text-primary"></i> soporte@winderjensyste.com</li>
                        <li><i class="fas fa-phone-alt mr-2 text-success"></i> 972554412</li>
                        <li><i class="fas fa-user-shield mr-2 text-danger"></i> av tuco 321</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
@stop

@section('css')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />
<style>
    body {
        background:rgb(248, 250, 250);
    }
    
    .card {
        border-radius: 15px;
        overflow: hidden;
        border: none;
    }
    
    .error-page-wrapper {
        min-height: 450px;
        border-radius: 15px;
        overflow: hidden;
    }
    
    .bg-gradient-success {
    background: linear-gradient(135deg, #28a745 0%, #1c402b 100%);
}

    .transition-all {
        transition: all 0.3s ease;
    }
    
    .btn {
        border-radius: 50px;
        font-weight: bold;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        transition: all 0.3s ease;
    }
    
    .btn:hover {
        transform: translateY(-3px);
        box-shadow: 0 6px 12px rgba(0,0,0,0.15);
    }
    
    .separator {
        position: relative;
        animation: pulse 2s infinite;
    }
    
    @keyframes pulse {
        0% {
            opacity: 0.7;
            width: 30%;
        }
        50% {
            opacity: 1;
            width: 50%;
        }
        100% {
            opacity: 0.7;
            width: 30%;
        }
    }
    
    #countdown {
        font-weight: bold;
        font-size: 1.2rem;
    }
</style>
@stop

@section('js')
<script>
    $(document).ready(function() {
        // Mostrar/ocultar información de soporte
        $("#supportBtn").click(function(e) {
            e.preventDefault();
            $("#supportInfo").slideToggle();
        });
        
        // Contador regresivo
        let countdown = 15;
        const countdownInterval = setInterval(function() {
            countdown--;
            $("#countdown").text(countdown);
            
            if (countdown <= 0) {
                clearInterval(countdownInterval);
                window.location.href = "{{ route('dashboard') }}";
            }
        }, 1000);
        
        // Detener el contador al hacer clic en cualquier botón
        $(".btn").click(function() {
            clearInterval(countdownInterval);
        });
        
        // Efecto de entrada
        $(".card").addClass("animate__animated animate__fadeIn");
    });
</script>
@stop