<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de Películas</title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #333; padding: 5px; text-align: left; }
        th { background-color: #f2f2f2; }
    </style>
</head>
<body>
    <h2>Lista de Películas</h2>
    <div style="margin-bottom: 15px;">Generado el: {{ date('d/m/Y H:i') }}</div>
    
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Título</th>
                <th>Duración</th>
                <th>Formato</th>
                <th>Categoría</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($peliculas as $pelicula)
                <tr>
                    <td>{{ $pelicula->id }}</td>
                    <td>{{ $pelicula->titulo }}</td>
                    <td>{{ floor($pelicula->duracion/60) }}h {{ $pelicula->duracion%60 }}min</td>
                    <td>{{ $pelicula->formato }}</td>
                    <td>{{ $pelicula->categoria->nombre }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div style="margin-top: 30px; font-size: 10px; text-align: center;">
        Sistema de Gestión de Películas © {{ date('Y') }}
    </div>
</body>
</html>