@extends('adminlte::page')

@section('title', 'Detalles de Película')

@section('content_header')
    <h1 class="m-0 text-dark">
        <i class="fas fa-film"></i> Detalles de Película
    </h1>
@stop

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card card-outline card-primary">
            <div class="card-header">
                <h3 class="card-title">{{ $pelicula->titulo }}</h3>
                <div class="card-tools">
                    <span class="badge bg-primary">#{{ $pelicula->id }}</span>
                </div>
            </div>
            
            <div class="card-body">
                <div class="row">
                    <div class="col-md-5 text-center">
                        <img src="{{ asset('imagenes/logo3.png') }}" 
                             alt="{{ $pelicula->titulo }}" 
                             class="img-fluid rounded" style="max-height: 400px;">
                        <div class="mt-2">
                            <span class="badge {{ $pelicula->estado == 'disponible' ? 'bg-success' : 'bg-danger' }}">
                                {{ ucfirst($pelicula->estado) }}
                            </span>
                        </div>
                    </div>
                    
                    <div class="col-md-7">
                        <div class="info-box bg-light mb-3">
                            <span class="info-box-icon bg-info">
                                <i class="far fa-clock"></i>
                            </span>
                            <div class="info-box-content">
                                <span class="info-box-text">Duración</span>
                                <span class="info-box-number">
                                    {{ floor($pelicula->duracion / 60) }}h {{ $pelicula->duracion % 60 }}min
                                </span>
                            </div>
                        </div>
                        
                        <div class="info-box bg-light mb-3">
                            <span class="info-box-icon bg-purple">
                                <i class="fas fa-compact-disc"></i>
                            </span>
                            <div class="info-box-content">
                                <span class="info-box-text">Formato</span>
                                <span class="info-box-number">{{ $pelicula->formato }}</span>
                            </div>
                        </div>
                        
                        <div class="info-box bg-light mb-3">
                            <span class="info-box-icon bg-success">
                                <i class="fas fa-tag"></i>
                            </span>
                            <div class="info-box-content">
                                <span class="info-box-text">Categoría</span>
                                <span class="info-box-number">{{ $pelicula->categoria->nombre }}</span>
                            </div>
                        </div>
                        
                        <div class="timeline">
                            <div class="time-label">
                                <span class="bg-blue">Historial</span>
                            </div>
                            <div>
                                <i class="fas fa-plus bg-blue"></i>
                                <div class="timeline-item">
                                    <span class="time">
                                        <i class="far fa-clock"></i> {{ $pelicula->created_at->format('H:i') }}
                                    </span>
                                    <h3 class="timeline-header">Creación</h3>
                                    <div class="timeline-body">
                                        {{ $pelicula->created_at->format('d M, Y') }}
                                    </div>
                                </div>
                            </div>
                            <div>
                                <i class="fas fa-sync-alt bg-blue"></i>
                                <div class="timeline-item">
                                    <span class="time">
                                        <i class="far fa-clock"></i> {{ $pelicula->updated_at->format('H:i') }}
                                    </span>
                                    <h3 class="timeline-header">Última actualización</h3>
                                    <div class="timeline-body">
                                        {{ $pelicula->updated_at->format('d M, Y') }}
                                    </div>
                                </div>
                            </div>
                            <div>
                                <i class="far fa-clock bg-gray"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-6 mb-2 mb-md-0">
                        <a href="{{ route('peliculas.index') }}" class="btn btn-default btn-block">
                            <i class="fas fa-arrow-left"></i> Volver
                        </a>
                    </div>
                    <div class="col-md-6">
                        <div class="d-flex">
                            <a href="{{ route('peliculas.edit', $pelicula) }}" class="btn btn-primary mr-2 flex-grow-1">
                                <i class="fas fa-edit"></i> Editar
                            </a>
                            <button class="btn btn-danger flex-grow-1" id="deleteBtn">
                                <i class="fas fa-trash"></i> Eliminar
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<form action="{{ route('peliculas.destroy', $pelicula) }}" method="POST" id="deleteForm" class="d-none">
    @csrf
    @method('DELETE')
</form>
@stop

@section('js')
<script>
    document.getElementById('deleteBtn').addEventListener('click', function() {
        Swal.fire({
            title: '¿Eliminar película?',
            text: "Esta acción no se puede deshacer",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById('deleteForm').submit();
            }
        });
    });
</script>
@stop