@extends('adminlte::page')

@section('title', 'Ver Perfil')

@section('content_header')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
@stop

@section('content')
<div class="container py-4">
    <div class="row justify-content-center">
        <div class="col-lg-9">
            <div class="profile-card">
                <div class="card-header">
                    <h4><i class="fas fa-user-circle mr-2"></i>Información de Perfil</h4>
                </div>
                
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show mb-4">
                            <i class="fas fa-check-circle mr-2"></i>
                            {{ session('success') }}
                            <button type="button" class="close" data-dismiss="alert">
                                <span>&times;</span>
                            </button>
                        </div>
                    @endif
                    
                    <div class="row">
                        <!-- Columna de la foto de perfil -->
                        <div class="col-lg-4 text-center profile-sidebar">
                            <div class="profile-img-wrapper">
                                @if(auth()->user()->foto)
                                    <div class="profile-img-container">
                                        <img id="profile-img" src="{{ asset('storage/' . auth()->user()->foto) }}" alt="Foto de perfil">
                                    </div>
                                @else
                                    <div class="profile-img-placeholder">
                                        <i class="fas fa-user"></i>
                                    </div>
                                @endif
                            </div>
                            
                            <div class="profile-user-info">
                                <h5>{{ auth()->user()->name }}</h5>
                                <span class="profile-role">
                                    @if(auth()->user()->roles->isNotEmpty())
                                        {{ auth()->user()->roles->first()->name }}
                                    @else
                                        Usuario
                                    @endif
                                </span>
                            </div>
                            
                            <div class="profile-membership">
                                <i class="fas fa-calendar-alt"></i>
                                <span>Miembro desde {{ auth()->user()->created_at->format('d/m/Y') }}</span>
                            </div>
                        </div>
                        
                        <!-- Columna de la información detallada -->
                        <div class="col-lg-8">
                            <div class="user-info-container">
                                <div class="info-group">
                                    <h6 class="info-title">Información Personal</h6>
                                    
                                    <div class="info-row">
                                        <div class="info-label">
                                            <i class="fas fa-user"></i>
                                            <span>Nombre Completo</span>
                                        </div>
                                        <div class="info-value">{{ auth()->user()->name }}</div>
                                    </div>
                                    
                                    <div class="info-row">
                                        <div class="info-label">
                                            <i class="fas fa-envelope"></i>
                                            <span>Correo Electrónico</span>
                                        </div>
                                        <div class="info-value">{{ auth()->user()->email }}</div>
                                    </div>
                                </div>
                                
                                <div class="info-group">
                                    <h6 class="info-title">Información de Cuenta</h6>
                                    
                                    <div class="info-row">
                                        <div class="info-label">
                                            <i class="fas fa-id-badge"></i>
                                            <span>Rol del Sistema</span>
                                        </div>
                                        <div class="info-value">
                                            @if(auth()->user()->roles->isNotEmpty())
                                                <span class="role-badge">{{ auth()->user()->roles->first()->name }}</span>
                                            @else
                                                <span class="role-badge role-none">Sin rol asignado</span>
                                            @endif
                                        </div>
                                    </div>
                                    
                                    <div class="info-row">
                                        <div class="info-label">
                                            <i class="fas fa-clock"></i>
                                            <span>Última actualización</span>
                                        </div>
                                        <div class="info-value">{{ auth()->user()->updated_at->format('d/m/Y H:i') }}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@stop

@section('css')
<style>
    :root {
        --primary-color: #5e72e4;
        --primary-light: #8392f7;
        --primary-dark: #324cdd;
        --secondary-color: #2dce89;
        --text-primary: #525f7f;
        --text-secondary: #8898aa;
        --bg-card: #ffffff;
        --bg-profile: #f7fafc;
        --shadow-soft: 0 0 35px 0 rgba(154, 161, 171, 0.15);
        --shadow-strong: 0 0 20px rgba(0, 0, 0, 0.08);
        --border-radius: 12px;
        --border-radius-sm: 6px;
    }
    
    body {
        background-color: #f8f9fe;
        color: var(--text-primary);
        font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
    }
    
    /* Card general */
    .profile-card {
        background-color: var(--bg-card);
        border-radius: var(--border-radius);
        box-shadow: var(--shadow-soft);
        overflow: hidden;
        margin-bottom: 30px;
        border: none;
    }
    
    .card-header {
        background: linear-gradient(87deg, var(--primary-color) 0, var(--primary-dark) 100%);
        padding: 1.25rem 1.5rem;
        border-bottom: none;
        color: white;
    }
    
    .card-header h4 {
        margin: 0;
        font-size: 1.1rem;
        font-weight: 500;
    }
    
    .card-body {
        padding: 1.5rem;
    }
    
    /* Columna de la imagen de perfil */
    .profile-sidebar {
        padding: 20px;
        background-color: var(--bg-profile);
        border-radius: var(--border-radius-sm);
    }
    
    .profile-img-wrapper {
        margin-bottom: 20px;
    }
    
    .profile-img-container {
        width: 150px;
        height: 150px;
        margin: 0 auto;
        border-radius: 50%;
        overflow: hidden;
        border: 4px solid white;
        box-shadow: var(--shadow-soft);
    }
    
    .profile-img-container img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }
    
    .profile-img-placeholder {
        width: 150px;
        height: 150px;
        margin: 0 auto;
        border-radius: 50%;
        background-color: #e9ecef;
        display: flex;
        align-items: center;
        justify-content: center;
        border: 4px solid white;
        box-shadow: var(--shadow-soft);
    }
    
    .profile-img-placeholder i {
        font-size: 60px;
        color: #adb5bd;
    }
    
    .profile-user-info {
        margin-bottom: 15px;
    }
    
    .profile-user-info h5 {
        margin-bottom: 5px;
        color: var(--primary-dark);
        font-weight: 600;
    }
    
    .profile-role {
        color: var(--secondary-color);
        font-size: 0.9rem;
        font-weight: 500;
    }
    
    .profile-membership {
        font-size: 0.85rem;
        color: var(--text-secondary);
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 5px;
        margin-top: 15px;
    }
    
    /* Columna de información */
    .user-info-container {
        background-color: var(--bg-profile);
        border-radius: var(--border-radius-sm);
        padding: 20px;
    }
    
    .info-group {
        margin-bottom: 25px;
    }
    
    .info-group:last-child {
        margin-bottom: 0;
    }
    
    .info-title {
        position: relative;
        font-size: 0.95rem;
        font-weight: 600;
        color: var(--primary-dark);
        margin-bottom: 18px;
        padding-bottom: 10px;
        border-bottom: 1px solid rgba(0, 0, 0, 0.05);
    }
    
    .info-row {
        display: flex;
        flex-wrap: wrap;
        margin-bottom: 15px;
        padding-bottom: 15px;
        border-bottom: 1px dashed rgba(0, 0, 0, 0.05);
    }
    
    .info-row:last-child {
        margin-bottom: 0;
        padding-bottom: 0;
        border-bottom: none;
    }
    
    .info-label {
        flex: 0 0 40%;
        font-weight: 500;
        color: var(--text-secondary);
        display: flex;
        align-items: center;
        gap: 8px;
    }
    
    .info-label i {
        color: var(--secondary-color);
        font-size: 14px;
        width: 16px;
        text-align: center;
    }
    
    .info-value {
        flex: 0 0 60%;
        color: var(--text-primary);
        font-weight: 500;
    }
    
    .role-badge {
        display: inline-block;
        background-color: rgba(45, 206, 137, 0.1);
        color: var(--secondary-color);
        padding: 3px 12px;
        border-radius: 50px;
        font-size: 0.8rem;
        font-weight: 500;
    }
    
    .role-none {
        background-color: rgba(94, 114, 228, 0.1);
        color: var(--primary-color);
    }
    
    /* Responsive */
    @media (max-width: 992px) {
        .profile-sidebar {
            margin-bottom: 20px;
            border-radius: var(--border-radius-sm) var(--border-radius-sm) 0 0;
        }
        
        .profile-img-container,
        .profile-img-placeholder {
            width: 120px;
            height: 120px;
        }
        
        .profile-img-placeholder i {
            font-size: 50px;
        }
    }
    
    @media (max-width: 768px) {
        .info-label, 
        .info-value {
            flex: 0 0 100%;
        }
        
        .info-value {
            margin-top: 8px;
            padding-left: 24px;
        }
    }
    
    /* Alerts */
    .alert-success {
        background-color: rgba(45, 206, 137, 0.1);
        border-color: rgba(45, 206, 137, 0.2);
        color: var(--secondary-color);
        border-radius: var(--border-radius-sm);
    }
</style>
@stop

@section('js')
<script>
    // No necesita JavaScript ya que es solo vista sin interactividad
</script>
@stop