<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Ticket</title>
    <style>
        body {
            font-family: monospace;
            font-size: 12px;
            padding: 10px;
        }
        html, body {
    height: auto;
    max-height: 100%;
    overflow: hidden;
}
        h2, h4 {
            text-align: center;
            margin: 0;
        }
        .line {
            border-top: 1px dashed #000;
            margin: 5px 0;
        }
        .center {
            text-align: center;
        }
        .qr {
    display: flex;
    justify-content: center;
    margin: 10px 0;
}
.qr img {
    width: 80px;
    height: 80px;
}

    </style>
</head>
<body>
<h2 class="center">CINESTACIÓN</h2>
<p class="center"><strong>RUC:</strong> 12345678901</p>
<p class="center">Av. Películas #123 - Lima</p>
<div class="line"></div>

@php
    // Si alquiler existe y su campo cliente tiene texto
    $clienteTexto = $venta->alquiler && $venta->alquiler->cliente 
        ? $venta->alquiler->cliente 
        : 'Venta directa';

    // Generar código de ticket
    $iniciales = strtoupper(substr(preg_replace('/[^A-Z]/', '', $clienteTexto), 0, 2));
    $codigo = "VENTA-{$iniciales}-{$venta->id}";
@endphp

    
    
    <p><strong>Ticket:</strong> #{{ $venta->id }}</p>
    <p><strong>Fecha:</strong> {{ $venta->created_at->format('d/m/Y H:i') }}</p>
    <p><strong>Cliente:</strong> {{ $clienteTexto }}</p>

    <div class="line"></div>
    <p><strong>Productos:</strong></p>

    @foreach($venta->detalles as $d)
        <p>- {{ $d->producto->nombre ?? 'Producto eliminado' }} x{{ $d->cantidad }} | S/ {{ number_format($d->subtotal, 2) }}</p>
    @endforeach

    <div class="line"></div>
    <p><strong>Total:</strong> S/ {{ number_format($venta->detalles->sum('subtotal'), 2) }}</p>
    <p><strong>Estado:</strong> {{ ucfirst($venta->estado) }}</p>
    <p><strong>Método de Pago:</strong> {{ $venta->metodo_pago ?? '---' }}</p>
    <p><strong>Código:</strong> {{ $codigo }}</p>
    <div class="line"></div>
    <div class="qr center">
    <img src="{{ $qrSrc }}" alt="QR Código">
</div>
    <p class="center">Escanea para validar</p>
    <div class="line"></div>
    <p class="center">¡Gracias por su compra!</p>
</body>
</html>
