@extends('adminlte::page')

@section('title', 'Detalle de Ventas')

@section('content_header')
<!-- ✅ Bootstrap 5.3 (última versión estable) -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>



<!-- ✅ jQuery (por si necesitas aparte) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- ✅ Font Awesome (íconos) -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">

@stop

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Filtros y búsqueda -->
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-light">
                    <h3 class="card-title">Filtros</h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('ventas.index') }}" method="GET" class="row">
                        <div class="col-md-3 mb-2">
                            <label for="fecha_inicio">Desde</label>
                            <input type="date" name="fecha_inicio" id="fecha_inicio" class="form-control form-control-sm" value="{{ request('fecha_inicio') }}">
                        </div>
                        <div class="col-md-3 mb-2">
                            <label for="fecha_fin">Hasta</label>
                            <input type="date" name="fecha_fin" id="fecha_fin" class="form-control form-control-sm" value="{{ request('fecha_fin') }}">
                        </div>
                        <div class="col-md-3 mb-2">
                            <label for="estado">Estado</label>
                            <select name="estado" id="estado" class="form-control form-control-sm">
                                <option value="">Todos</option>
                                <option value="pagado" {{ request('estado') == 'pagado' ? 'selected' : '' }}>Pagado</option>
                                <option value="pendiente" {{ request('estado') == 'pendiente' ? 'selected' : '' }}>Pendiente</option>
                            </select>
                        </div>
                        <div class="col-md-3 mb-2">
                            <label for="buscar">Buscar</label>
                            <div class="input-group input-group-sm">
                                <input type="text" name="buscar" id="buscar" class="form-control" placeholder="ID o cliente..." value="{{ request('buscar') }}">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Estadísticas rápidas -->
            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="small-box bg-gradient-white shadow-sm border-left border-info border-5">
                        <div class="inner text-dark">
                            <h3 class="text-info">S/ {{ number_format($ventas->sum('total'), 2) }}</h3>
                            <p class="mb-0">Total Ventas</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-shopping-cart text-info opacity-25"></i>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="small-box bg-gradient-white shadow-sm border-left border-success border-5">
                        <div class="inner text-dark">
                            <h3 class="text-success">{{ $ventas->where('estado', 'pagado')->count() }}</h3>
                            <p class="mb-0">Ventas Pagadas</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-check-circle text-success opacity-25"></i>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="small-box bg-gradient-white shadow-sm border-left border-warning border-5">
                        <div class="inner text-dark">
                            <h3 class="text-warning">{{ $ventas->where('estado', 'pendiente')->count() }}</h3>
                            <p class="mb-0">Ventas Pendientes</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-clock text-warning opacity-25"></i>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="small-box bg-gradient-white shadow-sm border-left border-danger border-5">
                        <div class="inner text-dark">
                            <h3 class="text-danger">{{ $ventas->count() }}</h3>
                            <p class="mb-0">Total Transacciones</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-chart-line text-danger opacity-25"></i>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Tabla de ventas -->
            <div class="card shadow-lg">
                

                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0" id="tablaVentas">
                        <thead>
    <tr class="encabezado-verde text-white">
                                    <th >ID</th>
                                    <th width="12%">Cliente</th>
                                    <th width="25%">Productos</th>
                                    <th >Fecha</th>
                                    
                                    <th  class="text-right">Subtotal</th>
                                    <th  class="text-center">Estado</th>
                                    <th  class="text-center">Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($ventas as $venta)
                                <tr class="{{ $venta->estado === 'pendiente' ? 'bg-light-warning' : '' }}">
                                    <td>{{ $venta->id }}</td>
                                    <td>
                                        @if($venta->alquiler && $venta->alquiler->cliente && is_object($venta->alquiler->cliente))
                                            <span class="font-weight-bold">{{ $venta->alquiler->cliente->nombre }}</span>
                                            <small class="text-muted">{{ $venta->alquiler->cliente->documento }}</small>
                                        @elseif($venta->alquiler && $venta->alquiler->cliente)
                                            <span class="text-muted">{{ $venta->alquiler->cliente }}</span>
                                        @else
                                            <span class="text-muted">Venta directa</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="producto-badges">
                                            @foreach($venta->detalles as $detalle)
                                            <span class="badge badge-light border border-success rounded-pill text-dark mb-1 px-2 py-0 small">
                                                <i class="fas fa-box-open text-success mr-1"></i>
                                                {{ $detalle->producto->nombre ?? 'Producto eliminado' }}
                                                <span class="badge badge-success ml-2 px-1 py-0 small"></span>
                                            </span>

                                            @endforeach
                                        </div>
                                    </td>
                                    <td>
                                    <span class="text-black font-weight-bold ">{{ $venta->created_at->format('d-m-Y') }}</span>
                                        <br>
                                        <small class="text-black font-weight-bold ">{{ $venta->created_at->format('h:i:s A') }}</small>

                                    </td>
                                    
                                    <td class="text-right font-weight-bold">S/ {{ number_format($venta->detalles->sum('subtotal'), 2) }}</td>
                                    <td class="text-center">
                                        @if($venta->estado === 'pagado')
                                            <span class="badge badge-success py-2 px-3">Pagado</span>
                                        @else
                                            <span class="badge badge-warning text-dark py-2 px-3">Pendiente</span>
                                        @endif
                                    </td>
                                    <td class="text-center">
    <div class="d-flex justify-content-center gap-1">
        <!-- Ver -->
        <button class="btn btn-sm" style="background-color:#00bcd4; color: white;" title="Ver detalle"
            data-toggle="modal" data-target="#modalVenta{{ $venta->id }}">
            <i class="fas fa-eye"></i>
        </button>

        <!-- Cobrar (solo si está pendiente) -->
        @if($venta->estado === 'pendiente')
        <button class="btn btn-sm" style="background-color:#ffc107; color: black;" title="Cobrar"
            onclick="abrirModalCobro({{ $venta->id }}, {{ $venta->detalles->sum('subtotal') }})">
            <i class="fas fa-pencil-alt"></i>
        </button>
        @endif

        <!-- Eliminar -->
        <form action="{{ route('ventas.destroy', $venta->id) }}" method="POST" class="d-inline delete-form">
            @csrf
            @method('DELETE')
            <button type="button" class="btn btn-sm delete-btn" style="background-color:#f44336; color: white;" title="Eliminar">
                <i class="fas fa-trash-alt"></i>
            </button>
        </form>

        <!-- Ticket PDF -->
        <button class="btn btn-sm" style="background-color:#607d8b; color: white;" title="Ver ticket"
            onclick="mostrarTicketPDF({{ $venta->id }})">
            <i class="fas fa-receipt"></i>
        </button>
    </div>
</td>

                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center py-5">
                                        <img src="{{ asset('img/no-data.svg') }}" alt="No hay datos" class="img-fluid" style="max-height: 100px;">
                                        <p class="text-muted mt-3">No hay ventas que coincidan con los filtros</p>
                                        <a href="{{ route('ventas.index') }}" class="btn btn-outline-primary btn-sm mt-2">
                                            <i class="fas fa-sync-alt mr-1"></i> Restablecer filtros
                                        </a>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>

                @if($ventas->hasPages())
                <div class="card-footer bg-light">
                    <div class="row align-items-center">
                        <div class="col-md-6 small">
                            Mostrando {{ $ventas->firstItem() ?? 0 }} a {{ $ventas->lastItem() ?? 0 }} de {{ $ventas->total() }} registros
                        </div>
                        <div class="col-md-6">
                            <nav aria-label="Page navigation">
                                <ul class="pagination justify-content-end mb-0">
                                    {{-- Previous Page Link --}}
                                    @if ($ventas->onFirstPage())
                                        <li class="page-item disabled">
                                            <span class="page-link bg-light border-0">
                                                <i class="fas fa-angle-left"></i>
                                            </span>
                                        </li>
                                    @else
                                        <li class="page-item">
                                            <a class="page-link bg-light" href="{{ $ventas->previousPageUrl() }}" rel="prev">
                                                <i class="fas fa-angle-left"></i>
                                            </a>
                                        </li>
                                    @endif

                                    {{-- Pagination Elements --}}
                                    @foreach ($ventas->getUrlRange(1, $ventas->lastPage()) as $page => $url)
                                        @if ($page == $ventas->currentPage())
                                            <li class="page-item active">
                                                <span class="page-link bg-success border-success">{{ $page }}</span>
                                            </li>
                                        @else
                                            <li class="page-item">
                                                <a class="page-link bg-light" href="{{ $url }}">{{ $page }}</a>
                                            </li>
                                        @endif
                                    @endforeach

                                    {{-- Next Page Link --}}
                                    @if ($ventas->hasMorePages())
                                        <li class="page-item">
                                            <a class="page-link bg-light" href="{{ $ventas->nextPageUrl() }}" rel="next">
                                                <i class="fas fa-angle-right"></i>
                                            </a>
                                        </li>
                                    @else
                                        <li class="page-item disabled">
                                            <span class="page-link bg-light border-0">
                                                <i class="fas fa-angle-right"></i>
                                            </span>
                                        </li>
                                    @endif
                                </ul>
                            </nav>
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>

@foreach($ventas as $venta)
<div class="modal fade" id="modalVenta{{ $venta->id }}" tabindex="-1" role="dialog" aria-labelledby="modalVentaLabel{{ $venta->id }}" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content border-0 shadow-sm">
            <div class="modal-header bg-info text-white">
                <h5 class="modal-title mb-0">
                    <i class="fas fa-file-invoice mr-2"></i> Detalle de Venta #{{ $venta->id }} - {{ $venta->created_at->format('d/m/Y H:i') }}
                </h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Cerrar">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body">
                <div class="row mb-4">
                    <div class="col-md-6">
                        <h6 class="text-muted mb-1">Cliente</h6>
                        <p class="font-weight-bold mb-0">
                            {{ $venta->alquiler->cliente ?? 'Venta directa' }}
                        </p>
                    </div>
                    <div class="col-md-6 text-right">
                        <h6 class="text-muted mb-1">Total</h6>
                        <p class="font-weight-bold text-primary mb-0">
                            S/ {{ number_format($venta->detalles->sum('subtotal'), 2) }}
                        </p>
                    </div>
                </div>

                @if($venta->detalles->count())
                <div class="table-responsive">
                    <table class="table table-borderless table-sm mb-0">
                        <thead class="bg-light text-dark border-bottom">
                            <tr>
                                <th width="50%">Producto</th>
                                <th width="15%" class="text-center">Cantidad</th>
                                <th width="15%" class="text-right">P. Unitario</th>
                                <th width="20%" class="text-right">Subtotal</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($venta->detalles as $detalle)
                            <tr>
                                <td>
                                    <span class="badge badge-light border border-success rounded-pill text-dark px-3 py-1">
                                        <i class="fas fa-box-open text-success mr-1"></i>
                                        {{ $detalle->producto->nombre ?? $detalle->nombre_producto ?? 'Producto eliminado' }}
                                    </span>
                                </td>
                                <td class="text-center">{{ $detalle->cantidad }}</td>
                                <td class="text-right">S/ {{ number_format($detalle->precio_unitario, 2) }}</td>
                                <td class="text-right">S/ {{ number_format($detalle->subtotal, 2) }}</td>
                            </tr>
                            @endforeach
                            <tr class="border-top bg-light">
                                <td colspan="3" class="text-right font-weight-bold">Total:</td>
                                <td class="text-right font-weight-bold text-primary">
                                    S/ {{ number_format($venta->detalles->sum('subtotal'), 2) }}
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                @else
                <div class="alert alert-warning mt-3">
                    <i class="fas fa-exclamation-triangle mr-2"></i> No hay productos registrados en esta venta.
                </div>
                @endif
            </div>

            <div class="modal-footer bg-light border-top-0">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fas fa-times mr-1"></i> Cerrar
                </button>
            </div>
        </div>
    </div>
</div>
@endforeach

<!-- Modal de Cobro - Versión Mejorada -->
<div class="modal fade" id="modalCobro" tabindex="-1" role="dialog" aria-labelledby="modalCobroLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header bg-gradient-warning text-white">
                <h5 class="modal-title font-weight-bold">
                    <i class="fas fa-cash-register mr-2"></i> Proceso de Cobro
                </h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            
            <form id="formCobro">
                <div class="modal-body">
                    <!-- Encabezado con información de la venta -->
                    <div class="row mb-4 border-bottom pb-3">
                        <div class="col-md-6">
                            <div class="d-flex align-items-center">
                                <div class="bg-light p-2 rounded mr-3">
                                    <i class="fas fa-receipt fa-2x text-warning"></i>
                                </div>
                                <div>
                                    <h6 class="mb-0 font-weight-bold">Venta #<span id="idVentaCobro"></span></h6>
                                    <small class="text-muted">Fecha: {{ now()->format('d/m/Y H:i') }}</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 text-right">
                            <h3 class="text-success font-weight-bold mb-0">
                                <small class="text-muted d-block">Total a pagar</small>
                                S/ <span id="totalVentaCobro"></span>
                            </h3>
                        </div>
                    </div>
                    
                    <!-- Método de pago -->
                    <div class="form-group">
                        <label for="metodoPago" class="font-weight-bold">Método de pago</label>
                        <div class="btn-group btn-group-toggle w-100" data-toggle="buttons" id="metodoPagoGroup">
                            <label class="btn btn-outline-primary active">
                                <input type="radio" name="metodoPago" value="efectivo" checked> 
                                <i class="fas fa-money-bill-wave mr-1"></i> Efectivo
                            </label>
                            <label class="btn btn-outline-primary">
                                <input type="radio" name="metodoPago" value="tarjeta"> 
                                <i class="fas fa-credit-card mr-1"></i> Tarjeta
                            </label>
                            <label class="btn btn-outline-primary">
                                <input type="radio" name="metodoPago" value="transferencia"> 
                                <i class="fas fa-exchange-alt mr-1"></i> Transferencia
                            </label>
                            <label class="btn btn-outline-primary">
                                <input type="radio" name="metodoPago" value="yape"> 
                                <i class="fab fa-whatsapp mr-1"></i> Yape
                            </label>
                            <label class="btn btn-outline-primary">
                                <input type="radio" name="metodoPago" value="plin"> 
                                <i class="fas fa-mobile-alt mr-1"></i> Plin
                            </label>
                        </div>
                    </div>
                    
                    <!-- Campos dinámicos según método de pago -->
                    <div class="row">
                        <!-- Campos para efectivo -->
                        <div class="col-md-6" id="camposEfectivo">
                            <div class="form-group">
                                <label for="montoRecibido" class="font-weight-bold">Monto recibido</label>
                                <div class="input-group input-group-lg">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text bg-light">S/</span>
                                    </div>
                                    <input type="number" step="0.01" min="0" id="montoRecibido" class="form-control form-control-lg" required>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label class="font-weight-bold">Vuelto</label>
                                <div class="input-group input-group-lg">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text bg-light">S/</span>
                                    </div>
                                    <input type="text" id="vueltoCalculado" class="form-control form-control-lg bg-light" readonly>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Campos para métodos digitales -->
                        <div class="col-md-6" id="camposDigital" style="display: none;">
                            <div class="form-group">
                                <label for="referenciaPago" class="font-weight-bold">Referencia de pago</label>
                                <input type="text" id="referenciaPago" class="form-control form-control-lg" placeholder="Número de operación o referencia">
                            </div>
                            
                            <div class="alert alert-info mt-3">
                                <i class="fas fa-info-circle mr-2"></i> 
                                <span id="infoMetodo">
                                    Ingrese el número de operación o comprobante del pago realizado.
                                </span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Observaciones -->
                    <div class="form-group mt-3">
                        <label for="observacionesCobro" class="font-weight-bold">
                            <i class="fas fa-clipboard mr-1"></i> Observaciones
                        </label>
                        <textarea id="observacionesCobro" class="form-control" rows="2" placeholder="Notas adicionales sobre el pago..."></textarea>
                    </div>
                </div>
                
                <div class="modal-footer bg-light">
                    <button type="button" class="btn btn-secondary btn-lg" data-dismiss="modal">
                        <i class="fas fa-times mr-1"></i> Cancelar
                    </button>
                    <button type="submit" class="btn btn-success btn-lg">
                        <i class="fas fa-check-circle mr-1"></i> Confirmar Cobro
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('css')
<style>
    /* 🔸 Fila en amarillo suave para ventas pendientes */
    .bg-light-warning {
        background-color: rgba(255, 243, 205, 0.3);
    }

    /* 🔸 Alineación central vertical de tablas */
    .table td, .table th {
        vertical-align: middle;
    }

    /* 🔸 Badges de productos */
    .producto-badges {
        max-height: 120px;
        overflow-y: auto;
        display: flex;
        flex-wrap: wrap;
        gap: 5px;
    }

    .producto-badges .badge {
        display: inline-flex;
        align-items: center;
        padding: 0.35em 0.65em;
        font-size: 0.875em;
        transition: all 0.2s;
    }

    .producto-badges .badge:hover {
        transform: translateY(-2px);
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }

    /* ✅ Encabezado de tabla verde sólido */
    .encabezado-verde {
        background-color: #28a745 !important;
    }

    .encabezado-verde th {
        background-color: #28a745 !important;
        color: #fff !important;
        border-color: #1e7e34 !important;
    }

    /* 🔸 Paginación y links */
    .pagination {
        margin-bottom: 0;
    }

    .page-link {
        margin: 0 3px;
        border-radius: 3px !important;
    }

    /* 🔸 Estilos para impresión */
    @media print {
        body * {
            visibility: hidden;
        }

        #imprimirContenido, #imprimirContenido * {
            visibility: visible;
        }

        #imprimirContenido {
            position: absolute;
            left: 0;
            top: 0;
            width: 100%;
        }

        .no-print {
            display: none !important;
        }
    }

    /* 🔸 Header degradado del modal de cobro */
    .modal-header.bg-gradient-warning {
        background: linear-gradient(135deg, #ffc107 0%, #ff8c00 100%);
        border-bottom: none;
    }

    /* 🔸 Botones del método de pago */
    #metodoPagoGroup .btn {
        border-radius: 0;
        padding: 0.5rem;
    }

    #metodoPagoGroup .btn.active {
        background-color: #007bff;
        color: white;
    }

    #metodoPagoGroup .btn:first-child {
        border-top-left-radius: 4px;
        border-bottom-left-radius: 4px;
    }

    #metodoPagoGroup .btn:last-child {
        border-top-right-radius: 4px;
        border-bottom-right-radius: 4px;
    }

    /* 🔸 Inputs del modal */
    .input-group-lg .form-control,
    .input-group-lg .input-group-text {
        height: calc(2.5em + 1rem + 2px);
        font-size: 1.1rem;
    }

    .modal-footer {
        border-top: 1px solid rgba(0,0,0,0.05);
    }

    /* 🔸 Hover bonito en métodos de pago */
    #metodoPagoGroup .btn:hover:not(.active) {
        background-color: rgba(0,123,255,0.1);
    }

    /* 🔸 Estilo limpio para el modal de detalle de venta */
    .modal-content {
        border: none !important;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
    }

    /* 🔸 Estilo para tabla del modal */
    .table-borderless td,
    .table-borderless th,
    .table td,
    .table th {
        border: none !important;
    }

    /* 🔸 Encabezado tabla modal */
    .modal .table thead th {
        border-bottom: 1px solid #dee2e6 !important;
        background-color: #f8f9fa !important;
        color: #495057;
    }

    .modal .table tbody tr:last-child {
        border-top: 1px solid #dee2e6;
    }
</style>


@endpush

@push('js')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap4.min.js"></script>

<script>
    function mostrarTicketPDF(id) {
    const url = `/ventas/${id}/ticket-pdf`;
    $('#pdfVentaIframe').attr('src', url);
    $('#modalPdfVenta').modal('show');
}

    function abrirModalCobro(ventaId, totalVenta) {
        $('#idVentaCobro').text(ventaId);
        $('#totalVentaCobro').text(totalVenta.toFixed(2));
        $('#montoRecibido').val('');
        $('#vueltoCalculado').val('');
        $('#formCobro').data('venta-id', ventaId);
        $('#formCobro').data('total-venta', totalVenta);
        
        // Resetear el formulario y mostrar campos adecuados
        $('#formCobro')[0].reset();
        $('#metodoPagoGroup input[value="efectivo"]').prop('checked', true).trigger('change');
        $('#camposEfectivo').show();
        $('#camposDigital').hide();
        
        // Enfocar el primer campo de entrada
        setTimeout(() => {
            $('#montoRecibido').focus();
        }, 500);
        
        $('#modalCobro').modal('show');
    }

    function calcularVuelto() {
        const total = parseFloat($('#formCobro').data('total-venta'));
        let monto = parseFloat($('#montoRecibido').val()) || 0;

        if (isNaN(monto)) {
            $('#vueltoCalculado').val('0.00');
            return;
        }

        const vuelto = monto >= total ? (monto - total).toFixed(2) : '0.00';
        $('#vueltoCalculado').val(vuelto);
    }

   

  

    $(function() {
        $('[data-toggle="tooltip"]').tooltip();

       

        $('.delete-btn').click(function(e) {
            e.preventDefault();
            const form = $(this).closest('form');

            Swal.fire({
                title: '¿Eliminar esta venta?',
                text: "Esta acción no se puede revertir",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#dc3545',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Sí, eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                }
            });
        });

        $('.btn-print').on('click', function () {
            const ventaId = $(this).data('venta-id');
            const modalContent = $('#modalVenta' + ventaId + ' .modal-body').html();
            const ventaTitle = $('#modalVenta' + ventaId + ' .modal-title').text();

            const printWindow = window.open('', '_blank');
            printWindow.document.write(`
                <html>
                    <head>
                        <title>${ventaTitle}</title>
                        <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
                        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css">
                        <style>
                            body { padding: 20px; font-family: Arial, sans-serif; }
                            .table { width: 100%; margin-bottom: 1rem; border-collapse: collapse; }
                            .table th, .table td { padding: 0.75rem; border: 1px solid #dee2e6; }
                            .table thead th { background-color: #f8f9fa; color: #495057; border-bottom: 2px solid #dee2e6; }
                            .text-right { text-align: right; }
                            .text-center { text-align: center; }
                            .no-print { display: none; }
                            .header-print { text-align: center; margin-bottom: 20px; padding-bottom: 15px; border-bottom: 1px solid #dee2e6; }
                            @media print { .no-print { display: none; } body { padding: 0; } }
                        </style>
                    </head>
                    <body>
                        <div class="header-print">
                            <h4>${ventaTitle}</h4>
                            <p class="text-muted">Documento generado el ${new Date().toLocaleString()}</p>
                        </div>
                        <div class="container mt-4">${modalContent}</div>
                        <script>
                            window.onload = function() {
                                window.print();
                                setTimeout(function() { window.close(); }, 1000);
                            }
                        <\/script>
                    </body>
                </html>
            `);
            printWindow.document.close();
        });

        $('#montoRecibido').on('input', calcularVuelto);

        $('#metodoPagoGroup').on('change', function() {
            const metodo = $(this).find('input:checked').val();
            
            if (metodo === 'efectivo') {
                $('#camposEfectivo').show();
                $('#camposDigital').hide();
            } else {
                $('#camposEfectivo').hide();
                $('#camposDigital').show();
                
                // Actualizar el mensaje informativo según el método
                let mensaje = '';
                switch(metodo) {
                    case 'tarjeta':
                        mensaje = 'Ingrese el número de operación de la transacción con tarjeta.';
                        break;
                    case 'transferencia':
                        mensaje = 'Ingrese el número de operación de la transferencia bancaria.';
                        break;
                    case 'yape':
                        mensaje = 'Ingrese el número de operación del pago por Yape.';
                        break;
                    case 'plin':
                        mensaje = 'Ingrese el número de operación del pago por Plin.';
                        break;
                    default:
                        mensaje = 'Ingrese el número de operación o comprobante del pago realizado.';
                }
                $('#infoMetodo').text(mensaje);
            }
        });

        

       
        // Manejar el envío del formulario de cobro
        $('#formCobro').on('submit', function(e) {
            e.preventDefault();

            const ventaId = $(this).data('venta-id');
            const totalVenta = parseFloat($(this).data('total-venta'));
            const metodoPago = $('#metodoPagoGroup input:checked').val();
            const montoRecibido = parseFloat($('#montoRecibido').val()) || 0;
            const referencia = $('#referenciaPago').val();
            const observaciones = $('#observacionesCobro').val();

            if (metodoPago === 'efectivo' && montoRecibido < totalVenta) {
                Swal.fire({
                    icon: 'error',
                    title: 'Monto insuficiente',
                    text: 'El monto ingresado no cubre el total de la venta.'
                });
                return;
            }

            if (metodoPago !== 'efectivo' && !referencia) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Referencia requerida',
                    text: 'Ingrese el número de operación o referencia del pago.'
                });
                return;
            }

            fetch(`/ventas/${ventaId}/cobrar`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({
                    monto_pagado: metodoPago === 'efectivo' ? montoRecibido : totalVenta,
                    metodo_pago: metodoPago,
                    referencia: referencia,
                    observaciones: observaciones
                })
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Venta cobrada',
                        text: data.message,
                        showCancelButton: true,
                        
                        cancelButtonText: 'Cerrar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            imprimirComprobante(ventaId);
                        }
                        location.reload();
                    });
                } else {
                    throw new Error(data.error || 'Error desconocido');
                }
            })
            .catch(err => {
                console.error(err);
                Swal.fire('Error', err.message, 'error');
            });
        });
    });
</script>
@endpush