@extends('adminlte::page')

@section('title', 'Detalle de Ventas')

@section('content_header')



<!-- ✅ jQuery (por si necesitas aparte) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- ✅ Font Awesome (íconos) -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">

@stop

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Filtros y búsqueda -->
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-light">
                    <h3 class="card-title">Filtros</h3>
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('ventas.index') }}" method="GET" class="row">
                        <div class="col-md-3 mb-2">
                            <label for="fecha_inicio">Desde</label>
                            <input type="date" name="fecha_inicio" id="fecha_inicio" class="form-control form-control-sm" value="{{ request('fecha_inicio') }}">
                        </div>
                        <div class="col-md-3 mb-2">
                            <label for="fecha_fin">Hasta</label>
                            <input type="date" name="fecha_fin" id="fecha_fin" class="form-control form-control-sm" value="{{ request('fecha_fin') }}">
                        </div>
                        <div class="col-md-3 mb-2">
                            <label for="estado">Estado</label>
                            <select name="estado" id="estado" class="form-control form-control-sm">
                                <option value="">Todos</option>
                                <option value="pagado" {{ request('estado') == 'pagado' ? 'selected' : '' }}>Pagado</option>
                                <option value="pendiente" {{ request('estado') == 'pendiente' ? 'selected' : '' }}>Pendiente</option>
                            </select>
                        </div>
                        <div class="col-md-3 mb-2">
                            <label for="buscar">Buscar</label>
                            <div class="input-group input-group-sm">
                                <input type="text" name="buscar" id="buscar" class="form-control" placeholder="ID o cliente..." value="{{ request('buscar') }}">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Estadísticas rápidas -->
            <div class="row mb-4">
    <div class="col-md-3">
        <div class="small-box bg-gradient-white shadow-sm border-left border-info border-5">
            <div class="inner text-dark">
                <h3 class="text-info">S/ {{ number_format($ventasTotales, 2) }}</h3>
                <p class="mb-0">Total Ventas</p>
            </div>
            <div class="icon">
                <i class="fas fa-shopping-cart text-info opacity-25"></i>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="small-box bg-gradient-white shadow-sm border-left border-success border-5">
            <div class="inner text-dark">
                <h3 class="text-success">{{ $ventasPagadas }}</h3>
                <p class="mb-0">Ventas Pagadas</p>
            </div>
            <div class="icon">
                <i class="fas fa-check-circle text-success opacity-25"></i>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="small-box bg-gradient-white shadow-sm border-left border-warning border-5">
            <div class="inner text-dark">
                <h3 class="text-warning">{{ $ventasPendientes }}</h3>
                <p class="mb-0">Ventas Pendientes</p>
            </div>
            <div class="icon">
                <i class="fas fa-clock text-warning opacity-25"></i>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="small-box bg-gradient-white shadow-sm border-left border-danger border-5">
            <div class="inner text-dark">
                <h3 class="text-danger">{{ $totalTransacciones }}</h3>
                <p class="mb-0">Total Transacciones</p>
            </div>
            <div class="icon">
                <i class="fas fa-chart-line text-danger opacity-25"></i>
            </div>
        </div>
    </div>
</div>


            <!-- Tabla de ventas -->
            <div class="card shadow-lg">
                

                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0" id="tablaVentas">
                        <thead>
    <tr class="encabezado-verde text-white">
                                    <th >ID</th>
                                    <th width="12%">Cliente</th>
                                    <th width="25%">Productos</th>
                                    <th >Fecha</th>
                                    
                                    <th  class="text-right">Subtotal</th>
                                    <th  class="text-center">Estado</th>
                                    <th  class="text-center">Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($ventas as $venta)
                                <tr class="{{ $venta->estado === 'pendiente' ? 'bg-light-warning' : '' }}">
                                    <td>{{ $venta->id }}</td>
                                    <td>
                                        @if($venta->alquiler && $venta->alquiler->cliente && is_object($venta->alquiler->cliente))
                                            <span class="font-weight-bold">{{ $venta->alquiler->cliente->nombre }}</span>
                                            <small class="text-muted">{{ $venta->alquiler->cliente->documento }}</small>
                                        @elseif($venta->alquiler && $venta->alquiler->cliente)
                                            <span class="text-muted">{{ $venta->alquiler->cliente }}</span>
                                        @else
                                            <span class="text-muted">Venta directa</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="producto-badges">
                                            @foreach($venta->detalles as $detalle)
                                            <span class="badge badge-light border border-success rounded-pill text-dark mb-1 px-2 py-0 small">
                                                <i class="fas fa-box-open text-success mr-1"></i>
                                                {{ $detalle->producto->nombre ?? 'Producto eliminado' }}
                                                <span class="badge badge-success ml-2 px-1 py-0 small"></span>
                                            </span>

                                            @endforeach
                                        </div>
                                    </td>
                                    <td>
                                    <span class="text-black font-weight-bold ">{{ $venta->created_at->format('d-m-Y') }}</span>
                                        <br>
                                        <small class="text-black font-weight-bold ">{{ $venta->created_at->format('h:i:s A') }}</small>

                                    </td>
                                    
                                    <td class="text-right font-weight-bold">S/ {{ number_format($venta->detalles->sum('subtotal'), 2) }}</td>
                                    <td class="text-center">
                                        @if($venta->estado === 'pagado')
                                            <span class="badge badge-success py-2 px-3">Pagado</span>
                                        @else
                                            <span class="badge badge-warning text-dark py-2 px-3">Pendiente</span>
                                        @endif
                                    </td>
                                    <td class="text-center">
    <div class="d-flex justify-content-center gap-1">
        <!-- Ver -->
        <button class="btn btn-sm" style="background-color:#00bcd4; color: white;" title="Ver detalle"
            data-toggle="modal" data-target="#modalVenta{{ $venta->id }}">
            <i class="fas fa-eye"></i>
        </button>
        @if($venta->estado === 'pendiente')
<button type="button" class="btn btn-sm btn-cobro"
    style="background-color:#ffc107; color: black;" title="Cobrar"
    data-id="{{ $venta->id }}"
    data-precio="{{ $venta->detalles->sum('subtotal') }}"
    data-cliente="{{ $venta->alquiler->cliente ?? 'Venta directa' }}"
    data-estado="{{ $venta->estado }}"
    data-productos='@json($venta->detalles->map(fn($d) => [
        'nombre' => $d->producto->nombre ?? 'Producto eliminado',
        'cantidad' => $d->cantidad
    ])->values())'
>
    <i class="fas fa-pencil-alt"></i>
</button>
@endif

@can('crear peliculas')
        <!-- Eliminar -->
        <form action="{{ route('ventas.destroy', $venta->id) }}" method="POST" class="d-inline delete-form">
            @csrf
            @method('DELETE')
            <button type="button" class="btn btn-sm delete-btn" style="background-color:#f44336; color: white;" title="Eliminar">
                <i class="fas fa-trash-alt"></i>
            </button>
        </form>
@endcan
        <!-- Ticket PDF -->
        <button class="btn btn-sm" style="background-color:#607d8b; color: white;" title="Ver ticket"
    onclick="mostrarTicketPDF({{ $venta->id }})">
    <i class="fas fa-receipt"></i>
</button>
    </div>
</td>

                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center py-5">
                                        <img src="{{ asset('img/no-data.svg') }}" alt="No hay datos" class="img-fluid" style="max-height: 100px;">
                                        <p class="text-muted mt-3">No hay ventas que coincidan con los filtros</p>
                                        <a href="{{ route('ventas.index') }}" class="btn btn-outline-primary btn-sm mt-2">
                                            <i class="fas fa-sync-alt mr-1"></i> Restablecer filtros
                                        </a>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>

                @if($ventas->hasPages())
                <div class="card-footer bg-light">
                    <div class="row align-items-center">
                        <div class="col-md-6 small">
                            Mostrando {{ $ventas->firstItem() ?? 0 }} a {{ $ventas->lastItem() ?? 0 }} de {{ $ventas->total() }} registros
                        </div>
                        <div class="col-md-6">
                            <nav aria-label="Page navigation">
                                <ul class="pagination justify-content-end mb-0">
                                    {{-- Previous Page Link --}}
                                    @if ($ventas->onFirstPage())
                                        <li class="page-item disabled">
                                            <span class="page-link bg-light border-0">
                                                <i class="fas fa-angle-left"></i>
                                            </span>
                                        </li>
                                    @else
                                        <li class="page-item">
                                            <a class="page-link bg-light" href="{{ $ventas->previousPageUrl() }}" rel="prev">
                                                <i class="fas fa-angle-left"></i>
                                            </a>
                                        </li>
                                    @endif

                                    {{-- Pagination Elements --}}
                                    @foreach ($ventas->getUrlRange(1, $ventas->lastPage()) as $page => $url)
                                        @if ($page == $ventas->currentPage())
                                            <li class="page-item active">
                                                <span class="page-link bg-success border-success">{{ $page }}</span>
                                            </li>
                                        @else
                                            <li class="page-item">
                                                <a class="page-link bg-light" href="{{ $url }}">{{ $page }}</a>
                                            </li>
                                        @endif
                                    @endforeach

                                    {{-- Next Page Link --}}
                                    @if ($ventas->hasMorePages())
                                        <li class="page-item">
                                            <a class="page-link bg-light" href="{{ $ventas->nextPageUrl() }}" rel="next">
                                                <i class="fas fa-angle-right"></i>
                                            </a>
                                        </li>
                                    @else
                                        <li class="page-item disabled">
                                            <span class="page-link bg-light border-0">
                                                <i class="fas fa-angle-right"></i>
                                            </span>
                                        </li>
                                    @endif
                                </ul>
                            </nav>
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>

@foreach($ventas as $venta)
<div class="modal fade" id="modalVenta{{ $venta->id }}" tabindex="-1" role="dialog" aria-labelledby="modalVentaLabel{{ $venta->id }}" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content border-0 shadow-sm">
            <div class="modal-header bg-info text-white">
                <h5 class="modal-title mb-0">
                    <i class="fas fa-file-invoice mr-2"></i> Detalle de Venta #{{ $venta->id }} - {{ $venta->created_at->format('d/m/Y H:i') }}
                </h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Cerrar">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body">
                <div class="row mb-4">
                    <div class="col-md-6">
                        <h6 class="text-muted mb-1">Cliente</h6>
                        <p class="font-weight-bold mb-0">
                            {{ $venta->alquiler->cliente ?? 'Venta directa' }}
                        </p>
                    </div>
                    <div class="col-md-6 text-right">
                        <h6 class="text-muted mb-1">Total</h6>
                        <p class="font-weight-bold text-primary mb-0">
                            S/ {{ number_format($venta->detalles->sum('subtotal'), 2) }}
                        </p>
                    </div>
                </div>

                @if($venta->detalles->count())
                <div class="table-responsive">
                    <table class="table table-borderless table-sm mb-0">
                        <thead class="bg-light text-dark border-bottom">
                            <tr>
                                <th width="50%">Producto</th>
                                <th width="15%" class="text-center">Cantidad</th>
                                <th width="15%" class="text-right">P. Unitario</th>
                                <th width="20%" class="text-right">Subtotal</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($venta->detalles as $detalle)
                            <tr>
                                <td>
                                    <span class="badge badge-light border border-success rounded-pill text-dark px-3 py-1">
                                        <i class="fas fa-box-open text-success mr-1"></i>
                                        {{ $detalle->producto->nombre ?? $detalle->nombre_producto ?? 'Producto eliminado' }}
                                    </span>
                                </td>
                                <td class="text-center">{{ $detalle->cantidad }}</td>
                                <td class="text-right">S/ {{ number_format($detalle->precio_unitario, 2) }}</td>
                                <td class="text-right">S/ {{ number_format($detalle->subtotal, 2) }}</td>
                            </tr>
                            @endforeach
                            <tr class="border-top bg-light">
                                <td colspan="3" class="text-right font-weight-bold">Total:</td>
                                <td class="text-right font-weight-bold text-primary">
                                    S/ {{ number_format($venta->detalles->sum('subtotal'), 2) }}
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                @else
                <div class="alert alert-warning mt-3">
                    <i class="fas fa-exclamation-triangle mr-2"></i> No hay productos registrados en esta venta.
                </div>
                @endif
            </div>

            <div class="modal-footer bg-light border-top-0">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fas fa-times mr-1"></i> Cerrar
                </button>
            </div>
        </div>
    </div>
</div>
@endforeach
<!-- Modal para mostrar el ticket en PDF -->
<div class="modal fade" id="modalPdfVenta" tabindex="-1" role="dialog" aria-labelledby="modalPdfVentaLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content border-0 shadow">
            <div class="modal-header bg-dark text-white">
                
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Cerrar">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body p-0">
                <iframe id="pdfVentaIframe" style="width: 100%; height: 600px; border: none;"></iframe>
            </div>
        </div>
    </div>
</div>
<!-- Modal de Cobro Mejorado -->
<div class="modal fade" id="modalCobro" tabindex="-1" role="dialog" aria-labelledby="modalCobroLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content border-0 shadow-lg">
            <!-- Encabezado con gradiente más suave -->
            <div class="modal-header bg-gradient-primary text-white py-3">
                <h5 class="modal-title font-weight-normal" id="modalCobroLabel">
                    <i class="fas fa-cash-register mr-2"></i>Procesar Pago
                </h5>
                <button type="button" class="close text-white opacity-75" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <!-- Cuerpo del modal con más espacio negativo -->
            <div class="modal-body p-4">
                <input type="hidden" id="alquiler_id">
                <div class="row">
                    <!-- Columna izquierda - Más compacta -->
                    <div class="col-md-6 pr-lg-4">
                        <!-- Total a pagar con menos énfasis visual -->
                        <div class="form-group mb-3">
                            <label class="text-muted small font-weight-bold mb-1">TOTAL A PAGAR</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text bg-white text-success border-right-0">
                                        <i class="fas "></i>
                                    </span>
                                </div>
                                <input type="text" id="precio" class="form-control form-control-lg border-left-0 pl-0 bg-white text-success font-weight-bold" readonly style="font-size: 1.5rem;">
                            </div>
                        </div>

                        <!-- Método de pago más minimalista -->
                        <div class="form-group mb-4">
                            <label class="text-muted small font-weight-bold mb-1">MÉTODO DE PAGO</label>
                            <select id="metodo_pago" class="form-control border-0 bg-light rounded-lg" onchange="mostrarOpcionesPago()">
                                <option value="efectivo">Efectivo</option>
                                <option value="yape">Yape</option>
                            </select>
                        </div>

                        <!-- Efectivo - Versión más limpia -->
                        <div id="pagoEfectivo" class="bg-light rounded-lg p-3 mb-3">
                            <div class="form-group mb-3">
                                <label class="text-muted small font-weight-bold mb-1">MONTO RECIBIDO</label>
                                <input type="number" id="monto_pagado" name="monto_pagado" class="form-control form-control-lg border-0 bg-white" placeholder="0.00">
                            </div>
                            <div class="d-flex justify-content-between align-items-center py-2 px-2">
                                <span class="text-muted small font-weight-bold">CAMBIO:</span>
                                <span id="vuelto" class="font-weight-bold text-success" style="font-size: 1.25rem;">S/0.00</span>
                            </div>
                        </div>

                        <!-- Yape - Versión más minimalista -->
                        <div id="pagoYape" style="display: none;" class="bg-light rounded-lg p-3">
                            <div class="text-center">
                                <img src="/imagenes/yape.jpg" alt="QR de Yape" class="img-fluid rounded mb-2" style="max-width: 180px;">
                                <p class="text-muted small mb-0">Escanea el código QR para pagar</p>
                            </div>
                        </div>
                    </div>

                    <!-- Columna derecha - Más minimalista -->
                    <div class="col-md-6 pl-lg-4">
                        <div class="bg-light rounded-lg p-3 h-100">
                            <h6 class="text-muted small font-weight-bold mb-3">RESUMEN DE VENTA</h6>
                            
                            <div class="mb-3">
                                <div class="d-flex justify-content-between mb-1">
                                    <span class="text-muted">ID Venta:</span>
                                    <span class="font-weight-medium" id="resumenId"></span>
                                </div>
                                <div class="d-flex justify-content-between mb-1">
                                    <span class="text-muted">Cliente:</span>
                                    <span class="font-weight-medium text-right" id="resumenCliente"></span>
                                </div>
                                <div class="d-flex justify-content-between">
                                    <span class="text-muted">Estado:</span>
                                    <span class="font-weight-medium text-right" id="resumenEstado"></span>
                                </div>
                            </div>

                            <hr class="my-3">

                            <h6 class="text-muted small font-weight-bold mb-2">PRODUCTOS</h6>
                            <div id="resumenProductos" class="d-flex flex-column gap-2">
                                <!-- Productos aparecerán aquí -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Pie del modal más discreto -->
            <div class="modal-footer bg-white border-0 pt-0">
                <button type="button" class="btn btn-outline-secondary btn-sm" data-dismiss="modal">
                    Cancelar
                </button>
                <button type="button" class="btn btn-primary btn-sm" onclick="procesarCobro()">
                    Confirmar Pago
                </button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('css')
<style>
    /* 🔸 Fila en amarillo suave para ventas pendientes */
    .bg-light-warning {
        background-color: rgba(255, 243, 205, 0.3);
    }

    /* 🔸 Alineación central vertical de tablas */
    .table td, .table th {
        vertical-align: middle;
    }

    /* 🔸 Badges de productos */
    .producto-badges {
        max-height: 120px;
        overflow-y: auto;
        display: flex;
        flex-wrap: wrap;
        gap: 5px;
    }

    .producto-badges .badge {
        display: inline-flex;
        align-items: center;
        padding: 0.35em 0.65em;
        font-size: 0.875em;
        transition: all 0.2s;
    }

    .producto-badges .badge:hover {
        transform: translateY(-2px);
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }

    /* ✅ Encabezado de tabla verde sólido */
    .encabezado-verde {
        background-color: #28a745 !important;
    }

    .encabezado-verde th {
        background-color: #28a745 !important;
        color: #fff !important;
        border-color: #1e7e34 !important;
    }

    /* 🔸 Paginación y links */
    .pagination {
        margin-bottom: 0;
    }

    .page-link {
        margin: 0 3px;
        border-radius: 3px !important;
    }

    /* 🔸 Estilos para impresión */
    @media print {
        body * {
            visibility: hidden;
        }

        #imprimirContenido, #imprimirContenido * {
            visibility: visible;
        }

        #imprimirContenido {
            position: absolute;
            left: 0;
            top: 0;
            width: 100%;
        }

        .no-print {
            display: none !important;
        }
    }

    /* 🔸 Header degradado del modal de cobro */
    .modal-header.bg-gradient-warning {
        background: linear-gradient(135deg, #ffc107 0%, #ff8c00 100%);
        border-bottom: none;
    }

    /* 🔸 Botones del método de pago */
    #metodoPagoGroup .btn {
        border-radius: 0;
        padding: 0.5rem;
    }

    #metodoPagoGroup .btn.active {
        background-color: #007bff;
        color: white;
    }

    #metodoPagoGroup .btn:first-child {
        border-top-left-radius: 4px;
        border-bottom-left-radius: 4px;
    }

    #metodoPagoGroup .btn:last-child {
        border-top-right-radius: 4px;
        border-bottom-right-radius: 4px;
    }

    /* 🔸 Inputs del modal */
    .input-group-lg .form-control,
    .input-group-lg .input-group-text {
        height: calc(2.5em + 1rem + 2px);
        font-size: 1.1rem;
    }

    .modal-footer {
        border-top: 1px solid rgba(0,0,0,0.05);
    }

    /* 🔸 Hover bonito en métodos de pago */
    #metodoPagoGroup .btn:hover:not(.active) {
        background-color: rgba(0,123,255,0.1);
    }

    /* 🔸 Estilo limpio para el modal de detalle de venta */
    .modal-content {
        border: none !important;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
    }

    /* 🔸 Estilo para tabla del modal */
    .table-borderless td,
    .table-borderless th,
    .table td,
    .table th {
        border: none !important;
    }

    /* 🔸 Encabezado tabla modal */
    .modal .table thead th {
        border-bottom: 1px solid #dee2e6 !important;
        background-color: #f8f9fa !important;
        color: #495057;
    }

    .modal .table tbody tr:last-child {
        border-top: 1px solid #dee2e6;
    }
</style>


@endpush

@push('js')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap4.min.js"></script>

<script>
    function mostrarTicketPDF(id) {
    const url = `/ventas/${id}/ticket-pdf`;
    $('#pdfVentaIframe').attr('src', url);
    $('#modalPdfVenta').modal('show');
}
$(document).on('click', '.btn-cobro', function () {
    const id = $(this).data('id');
    const precio = parseFloat($(this).data('precio'));
    const cliente = $(this).data('cliente');
    const estado = $(this).data('estado');
    const productos = $(this).data('productos');

    abrirModalCobro(id, precio, null, cliente, null, null, estado, productos);
});
function abrirModalCobro(id, precio, _, cliente, __, ___, estado, productos) {
    $('#alquiler_id').val(id);
    $('#precio').val(`S/${precio.toFixed(2)}`);
    $('#monto_pagado').val('');
    $('#vuelto').text('S/0.00');
    $('#metodo_pago').val('efectivo');
    mostrarOpcionesPago();

    // Llenar resumen lateral
    $('#resumenId').text(id);
    $('#resumenCliente').text(cliente ?? '-');
    $('#resumenEstado').text(estado ?? '-');
    llenarResumenProductos(productos || []);

    $('#modalCobro').modal('show');
}

function llenarResumenProductos(productos) {
    const contenedor = document.getElementById('resumenProductos');
    contenedor.innerHTML = '';

    productos.forEach(p => {
        const badge = document.createElement('span');
        badge.className = 'badge badge-success text-white px-2 py-1 small mb-1';
        badge.innerHTML = `<i class="fas fa-box-open mr-1"></i> ${p.nombre} x${p.cantidad}`;
        contenedor.appendChild(badge);
    });
}

function mostrarOpcionesPago() {
    const metodo = $('#metodo_pago').val();
    if (metodo === 'efectivo') {
        $('#pagoEfectivo').show();
        $('#pagoYape').hide();
    } else if (metodo === 'yape') {
        $('#pagoEfectivo').hide();
        $('#pagoYape').show();
    }
}

$('#monto_pagado').on('input', function () {
    const total = parseFloat($('#precio').val().replace('S/', '')) || 0;
    const pagado = parseFloat($(this).val()) || 0;
    const vuelto = pagado - total;
    $('#vuelto').text(vuelto >= 0 ? `S/${vuelto.toFixed(2)}` : 'S/0.00');
});

function procesarCobro() {
    const id = $('#alquiler_id').val();
    const metodo = $('#metodo_pago').val();
    const montoPagado = metodo === 'efectivo' ? parseFloat($('#monto_pagado').val()) || 0 : parseFloat($('#precio').val().replace('S/', '')) || 0;

    if (metodo === 'efectivo' && montoPagado < parseFloat($('#precio').val().replace('S/', ''))) {
        Swal.fire({
            icon: 'warning',
            title: 'Monto insuficiente',
            text: 'El monto recibido es menor al total.'
        });
        return;
    }

    fetch(`/ventas/${id}/cobrar`, {

        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: JSON.stringify({
            monto_pagado: montoPagado,
            metodo_pago: metodo
        })
    })
    .then(res => res.json())
    .then(data => {
        if (data.success) {
            Swal.fire({
                icon: 'success',
                title: 'Pago registrado',
                text: data.message
            }).then(() => {
                location.reload();
            });
        } else {
            throw new Error(data.error || 'Ocurrió un error al procesar el pago.');
        }
    })
    .catch(err => {
        Swal.fire('Error', err.message, 'error');
    });
}


</script>
@endpush