

<?php $__env->startSection('title', 'Dashboard Cinema VIP'); ?>

<?php $__env->startSection('content_header'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <!-- Sección de Estadísticas Rápidas -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="stat-card bg-gradient-primary">
                <div class="icon">
                    <i class="fas fa-film"></i>
                </div>
                <div class="content">
                    <h3><?php echo e($totalPeliculas); ?></h3>
                    <p>Películas Disponibles</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card bg-gradient-success">
                <div class="icon">
                    <i class="fas fa-ticket-alt"></i>
                </div>
                <div class="content">
                    <h3><?php echo e($totalProductos); ?></h3>
                    <p>Productos</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card bg-gradient-success">
                <div class="icon">
                    <i class="fas fa-ticket-alt"></i>
                </div>
                <div class="content">
                    <h3><?php echo e($totalProductos); ?></h3>
                    <p>Productos</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card bg-gradient-success">
                <div class="icon">
                    <i class="fas fa-ticket-alt"></i>
                </div>
                <div class="content">
                    <h3><?php echo e($totalProductos); ?></h3>
                    <p>Productos</p>
                </div>
            </div>
        </div>
       
        
    </div>

    <!-- Sección de Acciones Rápidas -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="quick-actions-card">
                <h3><i class="fas fa-bolt mr-2"></i>Acciones Rápidas</h3>
                <div class="actions-grid">
                    <a href="#" class="action-item bg-gradient-indigo">
                        <i class="fas fa-plus-circle"></i>
                        <span>Nueva Película</span>
                    </a>
                    <a href="#" class="action-item bg-gradient-teal">
                        <i class="fas fa-calendar-plus"></i>
                        <span>Crear Función</span>
                    </a>
                    <a href="<?php echo e(route('alquileres.create')); ?>" class="action-item bg-gradient-orange">
                        <i class="fas fa-user-plus"></i>
                        <span>Registrar Alquiler</span>
                    </a>
                    <a href="" class="action-item bg-gradient-purple">
                        <i class="fas fa-cash-register"></i>
                        <span>Realizar Venta</span>
                    </a>
                    <a href="#" class="action-item bg-gradient-pink">
                        <i class="fas fa-chart-line"></i>
                        <span>Ver Reportes</span>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Sección de Películas Destacadas -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="section-header">
                <h3><i class="fas fa-star mr-2"></i>Películas Destacadas</h3>
                <a href="#" class="view-all">Ver todas <i class="fas fa-arrow-right"></i></a>
            </div>
        </div>
    </div>

    <div class="row justify-content-center movie-grid">
        <!-- Película 1 -->
        <div class="col-md-3 col-sm-6">
            <div class="movie-card">
                <div class="movie-poster">
                    <img src="<?php echo e(asset('imagenes/mufasa.jpeg')); ?>" alt="Mufasa">
                    <div class="movie-badge">Nuevo</div>
                    <div class="movie-actions">
                        <button class="btn-action btn-play"><i class="fas fa-play"></i></button>
                        <button class="btn-action btn-info"><i class="fas fa-info"></i></button>
                        <button class="btn-action btn-ticket"><i class="fas fa-ticket-alt"></i></button>
                    </div>
                </div>
                <div class="movie-info">
                    <h4>Mufasa: El Rey León</h4>
                    <div class="movie-meta">
                        <span class="rating"><i class="fas fa-star"></i> 4.8</span>
                        <span class="duration"><i class="fas fa-clock"></i> 2h 15m</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Película 2 -->
        <div class="col-md-3 col-sm-6">
            <div class="movie-card">
                <div class="movie-poster">
                    <img src="<?php echo e(asset('imagenes/paddington.jpg')); ?>" alt="Paddington">
                    <div class="movie-badge bg-success">Popular</div>
                    <div class="movie-actions">
                        <button class="btn-action btn-play"><i class="fas fa-play"></i></button>
                        <button class="btn-action btn-info"><i class="fas fa-info"></i></button>
                        <button class="btn-action btn-ticket"><i class="fas fa-ticket-alt"></i></button>
                    </div>
                </div>
                <div class="movie-info">
                    <h4>Paddington</h4>
                    <div class="movie-meta">
                        <span class="rating"><i class="fas fa-star"></i> 4.6</span>
                        <span class="duration"><i class="fas fa-clock"></i> 1h 45m</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Película 3 -->
        <div class="col-md-3 col-sm-6">
            <div class="movie-card">
                <div class="movie-poster">
                    <img src="<?php echo e(asset('imagenes/sonic.jpg')); ?>" alt="Sonic">
                    <div class="movie-badge bg-warning">Próximamente</div>
                    <div class="movie-actions">
                        <button class="btn-action btn-play"><i class="fas fa-play"></i></button>
                        <button class="btn-action btn-info"><i class="fas fa-info"></i></button>
                        <button class="btn-action btn-ticket"><i class="fas fa-ticket-alt"></i></button>
                    </div>
                </div>
                <div class="movie-info">
                    <h4>Sonic 2</h4>
                    <div class="movie-meta">
                        <span class="rating"><i class="fas fa-star"></i> 4.7</span>
                        <span class="duration"><i class="fas fa-clock"></i> 2h 2m</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Película 4 -->
        <div class="col-md-3 col-sm-6">
            <div class="movie-card">
                <div class="movie-poster">
                    <img src="<?php echo e(asset('imagenes/moana.jpeg')); ?>" alt="Moana">
                    <div class="movie-badge bg-info">Clásico</div>
                    <div class="movie-actions">
                        <button class="btn-action btn-play"><i class="fas fa-play"></i></button>
                        <button class="btn-action btn-info"><i class="fas fa-info"></i></button>
                        <button class="btn-action btn-ticket"><i class="fas fa-ticket-alt"></i></button>
                    </div>
                </div>
                <div class="movie-info">
                    <h4>Moana</h4>
                    <div class="movie-meta">
                        <span class="rating"><i class="fas fa-star"></i> 4.9</span>
                        <span class="duration"><i class="fas fa-clock"></i> 1h 53m</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Sección de Próximos Estrenos -->
    <div class="row">
        <div class="col-12">
            <div class="section-header">
                <h3><i class="fas fa-calendar-alt mr-2"></i>Próximos Estrenos</h3>
                <a href="#" class="view-all">Ver calendario <i class="fas fa-arrow-right"></i></a>
            </div>
            <div class="upcoming-movies">
                <div class="upcoming-movie">
                    <img src="<?php echo e(asset('imagenes/upcoming1.jpg')); ?>" alt="Próximo 1">
                    <div class="upcoming-info">
                        <h5>Avatar 3</h5>
                        <span class="release-date">15 Dic 2024</span>
                    </div>
                </div>
                <div class="upcoming-movie">
                    <img src="<?php echo e(asset('imagenes/upcoming2.jpg')); ?>" alt="Próximo 2">
                    <div class="upcoming-info">
                        <h5>Super Mario Bros 2</h5>
                        <span class="release-date">10 Ene 2025</span>
                    </div>
                </div>
                <div class="upcoming-movie">
                    <img src="<?php echo e(asset('imagenes/upcoming3.jpg')); ?>" alt="Próximo 3">
                    <div class="upcoming-info">
                        <h5>Jurassic World</h5>
                        <span class="release-date">22 Nov 2024</span>
                    </div>
                </div>
                <div class="upcoming-movie">
                    <img src="<?php echo e(asset('imagenes/upcoming4.jpg')); ?>" alt="Próximo 4">
                    <div class="upcoming-info">
                        <h5>Frozen 3</h5>
                        <span class="release-date">5 Dic 2024</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    :root {
        --primary: #6C63FF;
        --secondary: #4D44DB;
        --success: #4CC9F0;
        --info: #4895EF;
        --warning: #F8961E;
        --danger: #F72585;
        --indigo: #5E60CE;
        --teal: #20B2AA;
        --orange: #FF7F50;
        --purple: #9D4EDD;
        --pink: #F72585;
        --gold: #FFD700;
    }

    body {
        background-color: #F8F9FA;
        font-family: 'Poppins', sans-serif;
    }

    /* Tarjetas de Estadísticas */
    .stat-card {
        border-radius: 12px;
        padding: 20px;
        color: white;
        display: flex;
        align-items: center;
        height: 100%;
        box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 30px rgba(0,0,0,0.2);
    }

    .stat-card .icon {
        font-size: 2rem;
        margin-right: 20px;
        opacity: 0.8;
    }

    .stat-card .content h3 {
        font-size: 1.8rem;
        font-weight: 700;
        margin-bottom: 5px;
    }

    .stat-card .content p {
        font-size: 0.9rem;
        opacity: 0.9;
        margin-bottom: 0;
    }

    /* Gradientes */
    .bg-gradient-primary {
        background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
    }

    .bg-gradient-success {
        background: linear-gradient(135deg, var(--success) 0%, #3A86FF 100%);
    }

    .bg-gradient-warning {
        background: linear-gradient(135deg, var(--warning) 0%, #F3722C 100%);
    }

    .bg-gradient-danger {
        background: linear-gradient(135deg, var(--danger) 0%, #B5179E 100%);
    }

    .bg-gradient-indigo {
        background: linear-gradient(135deg, var(--indigo) 0%, #4C4EDB 100%);
    }

    .bg-gradient-teal {
        background: linear-gradient(135deg, var(--teal) 0%, #2EC4B6 100%);
    }

    .bg-gradient-orange {
        background: linear-gradient(135deg, var(--orange) 0%, #FF9F1C 100%);
    }

    .bg-gradient-purple {
        background: linear-gradient(135deg, var(--purple) 0%, #7B2CBF 100%);
    }

    .bg-gradient-pink {
        background: linear-gradient(135deg, var(--pink) 0%, #FF7096 100%);
    }

    /* Acciones Rápidas */
    .quick-actions-card {
        background: white;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.05);
    }

    .quick-actions-card h3 {
        font-size: 1.3rem;
        color: #343A40;
        margin-bottom: 20px;
        display: flex;
        align-items: center;
    }

    .actions-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(180px, 1fr));
        gap: 15px;
    }

    .action-item {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        padding: 20px 10px;
        border-radius: 10px;
        color: white;
        text-align: center;
        transition: all 0.3s ease;
        text-decoration: none;
    }

    .action-item:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0,0,0,0.2);
        color: white;
    }

    .action-item i {
        font-size: 2rem;
        margin-bottom: 10px;
    }

    .action-item span {
        font-size: 0.9rem;
        font-weight: 500;
    }

    /* Secciones */
    .section-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }

    .section-header h3 {
        font-size: 1.4rem;
        color: #343A40;
        display: flex;
        align-items: center;
    }

    .view-all {
        color: var(--primary);
        font-weight: 500;
        text-decoration: none;
        transition: all 0.3s ease;
    }

    .view-all:hover {
        color: var(--secondary);
        text-decoration: underline;
    }

    /* Tarjetas de Películas */
    .movie-grid {
        margin-bottom: 30px;
    }

    .movie-card {
        background: white;
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        transition: all 0.3s ease;
        margin-bottom: 20px;
    }

    .movie-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 15px 30px rgba(0,0,0,0.2);
    }

    .movie-poster {
        position: relative;
        height: 300px;
        overflow: hidden;
    }

    .movie-poster img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.5s ease;
    }

    .movie-card:hover .movie-poster img {
        transform: scale(1.05);
    }

    .movie-badge {
        position: absolute;
        top: 15px;
        right: 15px;
        padding: 5px 10px;
        border-radius: 20px;
        font-size: 0.7rem;
        font-weight: 600;
        color: white;
        background: var(--primary);
    }

    .movie-badge.bg-success {
        background: var(--success);
    }

    .movie-badge.bg-warning {
        background: var(--warning);
    }

    .movie-badge.bg-info {
        background: var(--info);
    }

    .movie-actions {
        position: absolute;
        bottom: -50px;
        left: 0;
        right: 0;
        display: flex;
        justify-content: center;
        padding: 10px;
        background: linear-gradient(transparent, rgba(0,0,0,0.7));
        transition: all 0.3s ease;
    }

    .movie-card:hover .movie-actions {
        bottom: 0;
    }

    .btn-action {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        border: none;
        background: rgba(255,255,255,0.9);
        color: var(--primary);
        margin: 0 5px;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.3s ease;
    }

    .btn-action:hover {
        background: white;
        color: var(--secondary);
        transform: scale(1.1);
    }

    .btn-play {
        color: white;
        background: var(--primary);
    }

    .btn-play:hover {
        background: var(--secondary);
        color: white;
    }

    .movie-info {
        padding: 15px;
    }

    .movie-info h4 {
        font-size: 1.1rem;
        margin-bottom: 10px;
        color: #343A40;
    }

    .movie-meta {
        display: flex;
        justify-content: space-between;
        font-size: 0.8rem;
        color: #6C757D;
    }

    .movie-meta .rating {
        color: var(--warning);
    }

    /* Próximos Estrenos */
    .upcoming-movies {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
        gap: 20px;
    }

    .upcoming-movie {
        background: white;
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        transition: all 0.3s ease;
    }

    .upcoming-movie:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 25px rgba(0,0,0,0.2);
    }

    .upcoming-movie img {
        width: 100%;
        height: 120px;
        object-fit: cover;
    }

    .upcoming-info {
        padding: 15px;
    }

    .upcoming-info h5 {
        font-size: 1rem;
        margin-bottom: 5px;
        color: #343A40;
    }

    .release-date {
        font-size: 0.8rem;
        color: var(--info);
    }

    /* Responsive */
    @media (max-width: 992px) {
        .actions-grid {
            grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
        }
        
        .movie-poster {
            height: 250px;
        }
    }

    @media (max-width: 768px) {
        .stat-card {
            margin-bottom: 15px;
        }
        
        .actions-grid {
            grid-template-columns: repeat(2, 1fr);
        }
        
        .upcoming-movies {
            grid-template-columns: repeat(2, 1fr);
        }
    }

    @media (max-width: 576px) {
        .actions-grid {
            grid-template-columns: 1fr;
        }
        
        .upcoming-movies {
            grid-template-columns: 1fr;
        }
    }
</style>

<script>
  
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/acceso/dashboardper.blade.php ENDPATH**/ ?>