
<?php $__env->startSection('title', 'Servicio'); ?>

<head>
    <link rel="icon" href="<?php echo e(asset('icons/servicio.png')); ?>" type="image/x-icon">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
</head>

<?php $__env->startSection('content_header'); ?>
<div class="container-fluid">
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1 class="m-0 text-dark"><i class="fas fa-film mr-2"></i>Gestión de Alquileres</h1>
        </div>
        <div class="col-sm-6">
            <div class="float-sm-right">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('crear peliculas')): ?>
                <div class="btn-group" role="group">
                    <!-- Botón para Excel -->
                    <a href="<?php echo e(route('alquiler.export-excel')); ?>" class="btn btn-success btn-sm" title="Exportar a Excel">
                        <i class="fas fa-file-excel mr-1"></i> Excel
                    </a>
                    <!-- Botón para PDF -->
                    <a href="" class="btn btn-danger btn-sm ml-2" target="_blank" title="Descargar PDF">
                        <i class="fas fa-file-pdf mr-1"></i> PDF
                    </a>
                    
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    
                    <div class="card-tools">
                        <a href="<?php echo e(route('alquileres.create')); ?>" class="btn btn-success btn-sm">
                            <i class="fas fa-plus-circle mr-1"></i> Nuevo Alquiler
                        </a>
                    </div>
                    <div class="d-flex justify-content-between align-items-center">
        
                    <a href="<?php echo e(route('ventas.crear')); ?>" class="btn btn-success">
                        <i class="fas fa-plus"></i> Vender
                    </a>
                </div>
                </div>
                
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover table-striped text-center">
                            <thead class="thead-dark">
                                <tr>
                                    <th class="align-middle">ID</th>
                                    <th class="align-middle">Película</th>
                                    <th class="align-middle">Cliente</th>
                                    <th class="align-middle">Sala</th>
                                    <th class="align-middle">Horario</th>
                                    <th class="align-middle">Precio</th>
                                    <th class="align-middle">Estado</th>
                                    <th class="align-middle">Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $alquileres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alquiler): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="align-middle"><?php echo e($alquiler->id); ?></td>
                                        <td class="align-middle">
                                            <div class="d-flex align-items-center justify-content-center">
                                                <?php if($alquiler->pelicula->imagen): ?>
                                                    <img src="<?php echo e(asset('storage/' . $alquiler->pelicula->imagen)); ?>" 
                                                         alt="<?php echo e($alquiler->pelicula->titulo); ?>" 
                                                         class="img-thumbnail rounded-circle mr-2" 
                                                         style="width: 40px; height: 40px; object-fit: cover;">
                                                <?php endif; ?>
                                                <span><?php echo e($alquiler->pelicula->titulo ?? 'Sin título'); ?></span>
                                            </div>
                                        </td>
                                        <td class="align-middle"><?php echo e($alquiler->cliente); ?></td>
                                        <td class="align-middle">
                                            <?php if($alquiler->sala): ?>
                                                <span class="badge <?php echo e($alquiler->sala->tipo === 'VIP' ? 'bg-warning' : 'bg-primary'); ?>">
                                                    <?php echo $alquiler->sala->tipo === 'VIP' ? '<i class="fas fa-crown"></i> VIP' : '<i class="fas fa-chair"></i> NORMAL'; ?>

                                                </span>
                                                <strong><?php echo e($alquiler->sala->nombre); ?></strong>
                                            <?php else: ?>
                                                <span class="text-muted">Sin sala</span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="align-middle">
                                            <small class="d-block"><strong>Entrada:</strong> <?php echo e($alquiler->hora_entrada); ?></small>
                                            <small class="d-block"><strong>Salida:</strong> <?php echo e($alquiler->hora_salida); ?></small>
                                        </td>
                                        <td class="align-middle">
                                            <span class="badge bg-success">
                                                S/<?php echo e(number_format($alquiler->precio, 2)); ?>

                                            </span>
                                        </td>
                                        <td class="align-middle">
                                            <?php if($alquiler->estado === 'pagado'): ?>
                                                <span class="badge badge-success p-2">
                                                    <i class="fas fa-check-circle mr-1"></i> Pagado
                                                </span>
                                            <?php else: ?>
                                                <span class="badge badge-warning p-2">
                                                    <i class="fas fa-exclamation-circle mr-1"></i> Pendiente
                                                </span>
                                            <?php endif; ?>
                                        </td>
                                        <td class="align-middle">
                                            <div class="btn-group btn-group-sm" role="group">
                                                <a href="<?php echo e(route('alquileres.show', $alquiler)); ?>" 
                                                   class="btn btn-info" 
                                                   data-toggle="tooltip" 
                                                   title="Ver detalles">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('crear peliculas')): ?>
                                                <a href="<?php echo e(route('alquileres.edit', $alquiler)); ?>" 
                                                   class="btn btn-warning" 
                                                   data-toggle="tooltip" 
                                                   title="Editar">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <button class="btn btn-danger" 
                                                        onclick="eliminarAlquiler(<?php echo e($alquiler->id); ?>)"
                                                        data-toggle="tooltip" 
                                                        title="Eliminar">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                                <?php endif; ?>
                                                <!-- Mostrar botón de cobrar solo si está pendiente -->
                                                <?php if($alquiler->estado !== 'pagado'): ?>
                                                    <button class="btn btn-success" 
                                                            onclick="abrirModalCobro(<?php echo e($alquiler->id); ?>, <?php echo e($alquiler->precio); ?>)"
                                                            data-toggle="tooltip" 
                                                            title="Cobrar">
                                                        <i class="fas fa-cash-register"></i>
                                                    </button>
                                                <?php endif; ?>
                                                <button class="btn btn-secondary" 
        onclick="mostrarPDFTicket(<?php echo e($alquiler->id); ?>)"
        data-toggle="tooltip" 
        title="Ver Ticket PDF">
    <i class="fas fa-receipt"></i>
</button>

                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="card-footer clearfix">
                    <div class="float-right">
                        <?php echo e($alquileres->links('pagination::bootstrap-4')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal para mostrar el PDF del ticket -->
<div class="modal fade" id="modalPDFTicket" tabindex="-1" role="dialog" aria-labelledby="modalPDFTicketLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header bg-dark text-white">
        
        <button type="button" class="close text-white" data-dismiss="modal" aria-label="Cerrar">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body p-0" style="height: 80vh;">
        <iframe id="pdfTicketFrame" src="" frameborder="0" style="width:100%; height:100%;"></iframe>
      </div>
    </div>
  </div>
</div>

<!-- Modal de Cobro Mejorado -->
<div class="modal fade" id="modalCobro" tabindex="-1" role="dialog" aria-labelledby="modalCobroLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content border-0 shadow-lg">
            <!-- Encabezado con gradiente -->
            <div class="modal-header bg-gradient-primary text-white">
                <h5 class="modal-title" id="modalCobroLabel">
                    <i class="fas fa-cash-register mr-2"></i>Procesar Pago
                </h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            
            <!-- Cuerpo del modal -->
            <div class="modal-body p-4">
                <input type="hidden" id="alquiler_id">
                
                <div class="row">
                    <!-- Columna izquierda - Formulario de pago -->
                    <div class="col-md-6">
                        <div class="form-group mb-4">
                            <label class="font-weight-bold text-primary mb-2">Total a pagar:</label>
                            <div class="input-group input-group-lg">
                                <div class="input-group-prepend">
                                    <span class="input-group-text bg-success text-white py-3">
                                        <i class="fas fa-dollar-sign fa-lg"></i>
                                    </span>
                                </div>
                                <input type="text" id="precio" class="form-control form-control-lg font-weight-bold border-left-0 bg-light" readonly style="font-size: 1.25rem;">
                            </div>
                        </div>

                        <div class="form-group mb-4">
                            <label class="font-weight-bold text-primary mb-2">Método de Pago:</label>
                            <select id="metodo_pago" class="form-control form-control-lg select2" onchange="mostrarOpcionesPago()" style="width: 100%">
                                <option value="efectivo">Efectivo</option>
                                <option value="yape">Yape</option>
                            </select>
                        </div>

                        <!-- Opciones para efectivo -->
                        <div id="pagoEfectivo">
                            <div class="form-group mb-4">
                                <label class="font-weight-bold mb-2">Monto Recibido:</label>
                                <div class="input-group input-group-lg">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text bg-primary text-white py-3">
                                            <i class="fas fa-money-bill-wave fa-lg"></i>
                                        </span>
                                    </div>
                                    <input type="number" id="monto_pagado" name="monto_pagado" class="form-control form-control-lg" placeholder="0.00">
                                </div>
                            </div>
                            <div class="alert alert-success py-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <strong class="text-primary">Cambio:</strong>
                                    <span id="vuelto" class="font-weight-bold" style="font-size: 1.25rem;">S/0.00</span>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Opciones para Yape -->
                        <div id="pagoYape" style="display: none;">
                            <div class="card border-0 shadow-sm mb-4">
                                <div class="card-header bg-light">
                                    <h6 class="mb-0 font-weight-bold"><i class="fas fa-qrcode mr-2"></i>Pago con Yape</h6>
                                </div>
                                <div class="card-body d-flex flex-column align-items-center justify-content-center py-4">
                                    <div class="text-center mb-3">
                                        <img src="/imagenes/yape.jpg" alt="QR de Yape" class="img-fluid rounded shadow" style="max-width: 220px; border: 1px solid #eee;">
                                    </div>
                                    <div class="alert alert-info w-100 mb-0">
                                        <i class="fas fa-info-circle mr-2"></i> Escanea el código para realizar el pago
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                 <!-- Resumen del alquiler -->
                  
<div class="card border-0 shadow-sm mt-4">
    <div class="card-header bg-light">
        <h6 class="mb-0 font-weight-bold"><i class="fas fa-receipt mr-2"></i>Resumen</h6>
    </div>
    <div class="card-body">
        <ul class="list-group list-group-flush">
            <li class="list-group-item d-flex justify-content-between align-items-center px-0 py-2">
                <span class="text-muted">ID Alquiler:</span>
                <span class="font-weight-bold" id="resumenId"><?php echo e($alquiler->id); ?></span>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center px-0 py-2">
                <span class="text-muted">Película:</span>
                <span class="font-weight-bold text-right" id="resumenPelicula"><?php echo e($alquiler->pelicula->titulo ?? 'Sin título'); ?></span> <!-- O puedes agregar el nombre de la película si tienes esa relación -->
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center px-0 py-2">
                <span class="text-muted">Cliente:</span>
                <span class="font-weight-bold text-right" id="resumenCliente"><?php echo e($alquiler->cliente); ?></span>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center px-0 py-2">
                <span class="text-muted">Precio:</span>
                <span class="font-weight-bold text-right" id="resumenPrecio"><?php echo e($alquiler->precio); ?></span>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center px-0 py-2">
                <span class="text-muted">Hora de Entrada:</span>
                <span class="font-weight-bold text-right" id="resumenHoraEntrada"><?php echo e($alquiler->hora_entrada); ?></span>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center px-0 py-2">
                <span class="text-muted">Hora de Salida:</span>
                <span class="font-weight-bold text-right" id="resumenHoraSalida"><?php echo e($alquiler->hora_salida); ?></span>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center px-0 py-2">
                <span class="text-muted">Estado:</span>
                <span class="font-weight-bold text-right" id="resumenEstado"><?php echo e($alquiler->estado); ?></span>
            </li>
        </ul>
    </div>
</div>

                </div>
            </div>
            
            <!-- Pie del modal -->
            <div class="modal-footer bg-light">
                <button type="button" class="btn btn-outline-secondary px-4" data-dismiss="modal">
                    <i class="fas fa-times mr-2"></i> Cancelar
                </button>
                <button type="button" class="btn btn-primary px-4" onclick="procesarCobro()">
                    <i class="fas fa-check-circle mr-2"></i> Confirmar Pago
                </button>
            </div>
        </div>
    </div>
</div>

<?php $__env->startSection('footer'); ?>
<div class="float-right d-none d-sm-block">
    
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    function mostrarPDFTicket(id) {
    const url = `/alquileres/ticket/${id}`; // Tu ruta que genera el PDF
    document.getElementById('pdfTicketFrame').src = url;
    $('#modalPDFTicket').modal('show');
}

    $(function () {
        $('[data-toggle="tooltip"]').tooltip();
    });

    function abrirModalCobro(id, precio) {
        document.getElementById('alquiler_id').value = id;
        document.getElementById('precio').value = 'S/' + precio.toFixed(2);
        document.getElementById('monto_pagado').value = '';
        document.getElementById('vuelto').textContent = 'S/0.00';
        document.getElementById('pagoEfectivo').style.display = 'block';
        document.getElementById('pagoYape').style.display = 'none';
        document.getElementById('metodo_pago').value = 'efectivo';
        
        $('#modalCobro').modal('show');
    }

    document.getElementById("monto_pagado").addEventListener("input", function () {
        let precioText = document.getElementById("precio").value;
        let precio = parseFloat(precioText.replace('S/', ''));
        let montoPagado = parseFloat(this.value) || 0;
        let vuelto = montoPagado - precio;
        
        document.getElementById("vuelto").textContent = 
            vuelto >= 0 ? 'S/' + vuelto.toFixed(2) : "Monto insuficiente";
            
        if(vuelto >= 0) {
            document.getElementById("vuelto").classList.remove('text-danger');
            document.getElementById("vuelto").classList.add('text-success');
        } else {
            document.getElementById("vuelto").classList.remove('text-success');
            document.getElementById("vuelto").classList.add('text-danger');
        }
    });

    function mostrarOpcionesPago() {
        let metodo = document.getElementById("metodo_pago").value;
        document.getElementById("pagoEfectivo").style.display = metodo === "efectivo" ? "block" : "none";
        document.getElementById("pagoYape").style.display = metodo === "yape" ? "block" : "none";
    }

    function procesarCobro() {
        let id = document.getElementById('alquiler_id').value;
        let metodo = document.getElementById("metodo_pago").value;
        let montoPagado = metodo === "efectivo" ? parseFloat(document.getElementById('monto_pagado').value) : null;

        if (metodo === "efectivo" && (isNaN(montoPagado) || montoPagado <= 0)) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Ingrese un monto válido para efectivo',
                confirmButtonColor: '#3085d6'
            });
            return;
        }

        Swal.fire({
            title: 'Confirmar Cobro',
            html: `¿Estás seguro de procesar el cobro por <b>${document.getElementById('precio').value}</b>?`,
            icon: 'question',
            imageUrl: 'imagenes/cobro.png',
            imageWidth: 100,
            imageHeight: 100,
            imageAlt: 'Confirmación de cobro',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: '<i class="fas fa-check-circle"></i> Sí, cobrar',
            cancelButtonText: '<i class="fas fa-times-circle"></i> Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                let data = { 
                    metodo_pago: metodo,
                    _token: document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                };
                
                if (metodo === "efectivo") {
                    data.monto = montoPagado;
                }

                $.ajax({
                    url: `/alquileres/cobrar/${id}`,
                    type: 'POST',
                    data: data,
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Cobro realizado',
                            text: response.mensaje,
                            confirmButtonColor: '#3085d6'
                        }).then(() => {
                            if (response.mensaje.includes('éxito')) {
                                location.reload();
                            }
                        });
                    },
                    error: function(xhr) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'Hubo un error al procesar el cobro',
                            confirmButtonColor: '#3085d6'
                        });
                    }
                });
            }
        });
    }

    function eliminarAlquiler(id) {
        Swal.fire({
            title: '¿Eliminar alquiler?',
            text: "Esta acción no se puede deshacer",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: '<i class="fas fa-trash"></i> Sí, eliminar',
            cancelButtonText: '<i class="fas fa-times"></i> Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: `/alquileres/${id}`,
                    type: 'DELETE',
                    data: {
                        _token: document.querySelector('meta[name="csrf-token"]').content
                    },
                    success: function(response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Eliminado',
                                text: 'El alquiler ha sido eliminado',
                                confirmButtonColor: '#3085d6'
                            }).then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: 'No se pudo eliminar el alquiler',
                                confirmButtonColor: '#3085d6'
                            });
                        }
                    },
                    error: function() {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'Ocurrió un error al intentar eliminar',
                            confirmButtonColor: '#3085d6'
                        });
                    }
                });
            }
        });
    }
</script>
<?php $__env->stopPush(); ?>

<style>
    /* Estilos específicos para el modal mejorado */
    .bg-gradient-primary {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
    }
    
    .modal-content {
        border-radius: 0.5rem;
        overflow: hidden;
        border: none;
    }
    
    .modal-header {
        padding: 1.25rem 1.5rem;
        border-bottom: none;
    }
    
    .modal-body {
        padding: 1.5rem;
    }
    
    .modal-footer {
        border-top: 1px solid #eee;
        padding: 1rem 1.5rem;
    }
    
    .input-group-lg .form-control,
    .input-group-lg .input-group-prepend .input-group-text {
        height: calc(2.875rem + 2px);
        padding: 0.5rem 1rem;
        font-size: 1.1rem;
    }
    
    .select2-container--default .select2-selection--single {
        height: calc(2.875rem + 2px);
        padding: 0.5rem 1rem;
    }
    
    .select2-container--default .select2-selection--single .select2-selection__arrow {
        height: calc(2.875rem + 2px);
    }
    
    .card {
        border-radius: 0.5rem;
        border: none;
    }
    
    .list-group-item {
        border-color: rgba(0, 0, 0, 0.05);
        padding: 0.75rem 0;
    }
    .card-primary.card-outline {
        border-top: 3px solid #007bff;
    }
    .table-hover tbody tr:hover {
        background-color: rgba(0, 123, 255, 0.1);
    }
    .badge.bg-warning {
        color: #212529;
    }
    .select2 {
        width: 100% !important;
    }
    .img-thumbnail {
        padding: 0.25rem;
    }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/alquileres/index.blade.php ENDPATH**/ ?>