
<?php $__env->startSection('title', 'Crear Alquiler'); ?>

<?php $__env->startSection('content_header'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <!-- Tarjeta de búsqueda de DNI - Versión Responsiva -->
    <div class="row justify-content-center mb-4">
        <div class="col-12 col-md-8 col-lg-6">
            <div class="card card-search shadow-sm">
                <div class="card-body p-3 p-md-4">
                    <h5 class="card-title text-center mb-3 text-primary">
                        <i class="fas fa-id-card-alt mr-2"></i>Verificación de Cliente
                    </h5>
                    
                    <!-- Formulario de búsqueda -->
                    <form action="<?php echo e(route('dni.search')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="input-group input-group-lg mb-3">
                            <div class="input-group-prepend">
                                <span class="input-group-text bg-white border-right-0">
                                    <i class="fas fa-id-card text-primary"></i>
                                </span>
                            </div>
                            <input type="text" 
                                   class="form-control border-left-0" 
                                   id="dni" 
                                   name="dni" 
                                   placeholder="Ingrese DNI del cliente"
                                   maxlength="8" 
                                   required
                                   style="height: 50px;">
                            <div class="input-group-append">
                                <button type="submit" 
                                        class="btn btn-primary"
                                        style="height: 50px;">
                                    <i class="fas fa-search mr-1 d-none d-md-inline"></i> Buscar
                                </button>
                            </div>
                        </div>
                    </form>
                    
                    <!-- Resultados de búsqueda -->
                    <?php if(isset($data) && $data['estado'] && isset($data['resultado']['nombre_completo'])): ?>
                        <div class="alert alert-success alert-dismissible fade show mt-3">
                            <div class="d-flex align-items-center">
                                <i class="fas fa-check-circle fa-2x mr-3"></i>
                                <div>
                                    <h6 class="alert-heading mb-1">Cliente encontrado</h6>
                                    <p class="mb-0"><?php echo e($data['resultado']['nombre_completo']); ?></p>
                                </div>
                            </div>
                        </div>
                    <?php elseif(isset($data) && !$data['estado']): ?>
                        <div class="alert alert-danger alert-dismissible fade show mt-3">
                            <div class="d-flex align-items-center">
                                <i class="fas fa-exclamation-circle fa-2x mr-3"></i>
                                <div>
                                    <h6 class="alert-heading mb-1">Cliente no encontrado</h6>
                                    <p class="mb-0">No se encontraron resultados para el DNI ingresado</p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Resto del formulario de alquiler -->
    <div class="row justify-content-center">
        <div class="col-12 col-lg-10">
            <div class="card card-form">
                <div class="card-header bg-primary-gradient">
                    <h3 class="card-title mb-0 text-white">
                        <i class="fas fa-ticket-alt mr-2"></i>Datos del Alquiler
                    </h3>
                </div>
                <div class="card-body p-3 p-md-4">
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger border-left-danger">
                            <h5 class="alert-heading d-flex align-items-center">
                                <i class="fas fa-exclamation-circle mr-2"></i>
                                <span>Por favor corrige los siguientes errores:</span>
                            </h5>
                            <ul class="mb-0 ml-3">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <form id="alquiler-form" action="<?php echo e(route('alquileres.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        
                        <div class="row">
                            <!-- Columna Izquierda -->
                            <div class="col-md-6">
                                <!-- Película -->
                                <div class="form-group mb-3 mb-md-4">
                                    <label for="pelicula_search" class="form-label">
                                        <i class="fas fa-film text-primary mr-2"></i>Selección de Película
                                    </label>
                                    <div class="position-relative">
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text bg-light">
                                                    <i class="fas fa-search"></i>
                                                </span>
                                            </div>
                                            <input type="text" id="pelicula_search" class="form-control" 
                                                placeholder="Buscar película por título..." autocomplete="off" required>
                                        </div>
                                        <div id="search-results" class="search-results list-group mt-1 shadow-sm" style="display: none;"></div>
                                    </div>
                                    <input type="hidden" name="pelicula_id" id="pelicula_id">
                                    <input type="hidden" id="duracion_pelicula">
                                    
                                    <div id="selected-movie" class="mt-3 d-none">
                                        <div class="selected-movie-card d-flex align-items-center p-2 border rounded">
                                            <div id="movie-poster" class="mr-3 rounded bg-light" style="width: 60px; height: 80px; display: flex; align-items: center; justify-content: center;">
                                                <i class="fas fa-film text-muted fa-2x"></i>
                                            </div>
                                            <div>
                                                <h6 id="movie-title" class="mb-1 font-weight-bold">Título de película</h6>
                                                <p class="mb-0 text-muted small">
                                                    <i class="far fa-clock mr-1"></i>
                                                    <span id="movie-duration">0</span> minutos
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Selección de Sala -->
                                <?php if(isset($salas) && count($salas) > 0): ?>
                                    <div class="form-group mb-3 mb-md-4">
                                        <label for="sala_id" class="form-label">
                                            <i class="fas fa-door-open text-primary mr-2"></i>Sala
                                        </label>
                                        <select name="sala_id" id="sala_id" class="form-control select2" required>
                                            <option value="" disabled selected>Seleccione una sala</option>
                                            <?php $__currentLoopData = $salas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sala): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($sala->id); ?>" <?php echo e(old('sala_id') == $sala->id ? 'selected' : ''); ?>>
                                                    <?php echo e($sala->nombre); ?> (<?php echo e($sala->tipo); ?>)
                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                <?php else: ?>
                                    <div class="alert alert-warning border-left-warning">
                                        <div class="d-flex align-items-center">
                                            <i class="fas fa-exclamation-triangle text-warning mr-3 fa-2x"></i>
                                            <div>
                                                <h5 class="mb-1">Sin salas disponibles</h5>
                                                <p class="mb-0">No hay salas registradas en el sistema.</p>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                            
                            <!-- Columna Derecha -->
                            <div class="col-md-6">
                                <!-- Datos del Cliente -->
                                <div class="form-group mb-3 mb-md-4">
                                    <label for="cliente" class="form-label">
                                        <i class="fas fa-user text-primary mr-2"></i>Cliente
                                    </label>
                                    <input type="text" class="form-control" id="cliente" name="cliente" 
                                        placeholder="Nombre completo del cliente" 
                                        value="<?php echo e(isset($data) && isset($data['resultado']['nombre_completo']) ? $data['resultado']['nombre_completo'] : old('cliente')); ?>"
                                        required>
                                </div>

                                <!-- Horario -->
                                <div class="row">
                                    <div class="col-6">
                                        <div class="form-group">
                                            <label for="hora_entrada" class="form-label">
                                                <i class="fas fa-hourglass-start text-primary mr-2"></i>Entrada
                                            </label>
                                            <input type="time" name="hora_entrada" id="hora_entrada" 
                                                class="form-control" value="<?php echo e(old('hora_entrada')); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="form-group">
                                            <label for="hora_salida" class="form-label">
                                                <i class="fas fa-hourglass-end text-primary mr-2"></i>Salida
                                            </label>
                                            <input type="time" name="hora_salida" id="hora_salida" 
                                                class="form-control bg-light" value="<?php echo e(old('hora_salida')); ?>" readonly>
                                        </div>
                                    </div>
                                </div>

                                <!-- Precio -->
                                <div class="form-group">
                                    <label for="precio" class="form-label">
                                        <i class="fas fa-tag text-primary mr-2"></i>Precio
                                    </label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text bg-light">S/</span>
                                        </div>
                                        <input type="number" name="precio" id="precio" class="form-control" 
                                            step="0.01" min="0" placeholder="0.00" required>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Botones de acción -->
                        <div class="d-flex flex-column flex-md-row justify-content-end mt-4 pt-3 border-top">
                            <a href="<?php echo e(route('alquileres.index')); ?>" class="btn btn-outline-secondary btn-lg mx-0 mx-md-2 mb-2 mb-md-0">
                                <i class="fas fa-times mr-2"></i> Cancelar
                            </a>
                            <button type="submit" class="btn btn-success btn-lg" id="btn-submit">
                                <i class="fas fa-save mr-2"></i> Guardar Alquiler
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<style>
    /* Estilos generales con colores vibrantes */
body {
    background-color: #f8fafc;
    color: #334155;
}

.text-gradient {
    color: #00d474; /* Cambio a verde brillante */
    -webkit-text-fill-color: initial;
    background: none;
}

.card {
    border-radius: 8px;
    overflow: hidden;
    transition: all 0.2s ease;
    border: 1px solid #e2e8f0;
}

.bg-gradient-primary {
    background: #00d474; /* Cambio a verde brillante */
}

/* Formularios */
.form-control {
    border-radius: 6px;
    border: 1px solid #e2e8f0;
    padding: 10px 12px;
    height: auto;
    font-size: 14px;
    transition: all 0.2s ease;
}

.form-control:focus {
    border-color: #00d474; /* Cambio a verde brillante */
    box-shadow: 0 0 0 2px rgba(0, 212, 116, 0.15);
}

.input-group-text {
    background-color: #f1f5f9;
    border: 1px solid #e2e8f0;
    border-radius: 6px;
    padding: 10px 12px;
}

/* Botones */
.btn {
    border-radius: 6px;
    padding: 8px 16px;
    font-size: 14px;
    font-weight: 500;
    transition: all 0.2s ease;
}

/* Botón primario (verde) */
.btn-primary {
    background: #00d474;
    border: none;
}

.btn-primary:hover, .btn-primary:focus {
    background: #00bd68;
    box-shadow: 0 3px 8px rgba(0, 212, 116, 0.25);
    transform: translateY(-1px);
}

/* Botón outline primary (verde) */
.btn-outline-primary {
    color: #00d474;
    border-color: #00d474;
}

.btn-outline-primary:hover {
    background: #00d474;
    border-color: #00d474;
    color: white;
}

/* Botón secundario (naranja/editar) */
.btn-warning, .btn-editar {
    background: #ff9f10;
    border: none;
    color: white;
}

.btn-warning:hover, .btn-editar:hover {
    background: #f59000;
    box-shadow: 0 3px 8px rgba(255, 159, 16, 0.25);
    transform: translateY(-1px);
    color: white;
}

/* Botón danger (rojo/eliminar) */
.btn-danger, .btn-eliminar {
    background: #ff3b5c;
    border: none;
    color: white;
}

.btn-danger:hover, .btn-eliminar:hover {
    background: #e6354f;
    box-shadow: 0 3px 8px rgba(255, 59, 92, 0.25);
    transform: translateY(-1px);
}

/* Botón de WhatsApp (verde) */
.btn-whatsapp {
    background: #00d474;
    border: none;
    color: white;
}

.btn-whatsapp:hover {
    background: #00bd68;
    box-shadow: 0 3px 8px rgba(0, 212, 116, 0.25);
    transform: translateY(-1px);
}

/* Botón outline secundario */
.btn-outline-secondary {
    color: #64748b;
    border-color: #e2e8f0;
}

.btn-outline-secondary:hover {
    background: #f1f5f9;
    color: #475569;
    border-color: #cbd5e1;
}

/* Labels */
.form-label {
    color: #475569;
    font-size: 14px;
    font-weight: 500;
    margin-bottom: 8px;
}

/* Texto de acento (violeta) */
.text-accent, .super-admin {
    color: #a64dff !important;
}

/* Alerts */
.alert {
    border-radius: 6px;
    border: none;
    padding: 12px 16px;
}

.alert-success {
    background-color: rgba(0, 212, 116, 0.1);
    color: #007e45;
}

.alert-danger {
    background-color: rgba(255, 59, 92, 0.1);
    color: #d91a3d;
}

.alert-warning {
    background-color: rgba(255, 159, 16, 0.1);
    color: #b36b00;
}

/* Búsqueda de película */
.search-results {
    position: absolute;
    z-index: 1050;
    width: 100%;
    max-height: 250px;
    overflow-y: auto;
    border-radius: 6px;
    background-color: #fff;
    box-shadow: 0 4px 12px rgba(15, 23, 42, 0.08);
    border: 1px solid #e2e8f0;
    margin-top: 4px;
}

.search-results a {
    padding: 10px 12px;
    display: block;
    text-decoration: none;
    color: #334155;
    border-bottom: 1px solid #f1f5f9;
    transition: all 0.15s ease;
}

.search-results a:last-child {
    border-bottom: none;
}

.search-results a:hover {
    background-color: #f1f5f9;
}

.selected-movie-card {
    border-radius: 6px;
    border: 1px solid #e2e8f0;
    background-color: #f8fafc;
}

/* Select2 customization */
.select2-container--default .select2-selection--single {
    height: auto;
    padding: 8px 12px;
    border: 1px solid #e2e8f0;
    border-radius: 6px;
}

.select2-container--default .select2-selection--single .select2-selection__arrow {
    height: 40px;
}

.select2-container--default .select2-selection--single .select2-selection__rendered {
    line-height: 24px;
    padding-left: 0;
    color: #334155;
}

.select2-container--default .select2-results__option--highlighted[aria-selected] {
    background-color: #00d474;
}

/* Card header */
.card-header {
    padding: 16px;
    border-bottom: 1px solid #e2e8f0;
}

/* Iconos */
.text-primary {
    color: #00d474 !important; /* Cambio a verde brillante */
}

.text-warning {
    color: #ff9f10 !important; /* Naranja ámbar */
}

.text-danger {
    color: #ff3b5c !important; /* Rojo */
}

.text-muted {
    color: #64748b !important;
}

/* Títulos */
h1, h2, h3, h4, h5, h6 {
    color: #1e293b;
}

/* Estilos adicionales para formulario de confirmación */
.border-bottom {
    border-bottom-color: #e2e8f0 !important;
}

/* Sombras sutiles */
.shadow-sm {
    box-shadow: 0 1px 3px rgba(15, 23, 42, 0.05), 0 1px 2px rgba(15, 23, 42, 0.03) !important;
}

/* Switch de Activo/Inactivo */
.switch {
    position: relative;
    display: inline-block;
    width: 50px;
    height: 24px;
}

.switch input {
    opacity: 0;
    width: 0;
    height: 0;
}

.slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #cbd5e1;
    transition: .4s;
    border-radius: 24px;
}

.slider:before {
    position: absolute;
    content: "";
    height: 18px;
    width: 18px;
    left: 3px;
    bottom: 3px;
    background-color: white;
    transition: .4s;
    border-radius: 50%;
}

input:checked + .slider {
    background-color:rgb(15, 199, 116);
}

input:focus + .slider {
    box-shadow: 0 0 1px #00d474;
}

input:checked + .slider:before {
    transform: translateX(26px);
}

/* Estilos para texto de roles especiales */
.super-admin {
    color: #a64dff;
    font-weight: 500;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('js'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
    // Actualizar las instancias de SweetAlert2 con los nuevos colores vibrantes
$(document).ready(function() {
    // Inicializar Select2
    $('.select2').select2({
        placeholder: "Seleccione una sala",
        allowClear: true,
        theme: "classic",
        width: '100%'
    });

    // Función para buscar películas
    $('#pelicula_search').on('keyup', function() {
        var searchTerm = $(this).val();
        $('#search-results').hide();

        if (searchTerm.length > 2) {
            $.ajax({
                url: '<?php echo e(route('peliculas.search')); ?>',
                method: 'GET',
                data: { term: searchTerm },
                success: function(response) {
                    $('#search-results').empty();

                    if(response.peliculas.length > 0) {
                        response.peliculas.forEach(function(pelicula) {
                            $('#search-results').append(
                                '<a href="#" class="d-flex align-items-center" ' +
                                'data-id="' + pelicula.id + '" ' +
                                'data-title="' + pelicula.titulo + '" ' +
                                'data-duracion="' + pelicula.duracion + '" ' +
                                'data-imagen="' + (pelicula.imagen ? pelicula.imagen : '') + '">' +
                                (pelicula.imagen ? '<img src="/storage/' + pelicula.imagen + '" class="rounded mr-3" width="35" height="50" style="object-fit: cover;">' : 
                                '<div class="rounded mr-3 bg-light d-flex align-items-center justify-content-center" style="width: 35px; height: 50px;"><i class="fas fa-film text-muted"></i></div>') +
                                '<div>' +
                                '<div class="font-weight-medium">' + pelicula.titulo + '</div>' +
                                '<div class="text-muted small">' + pelicula.duracion + ' min</div>' +
                                '</div></a>'
                            );
                        });
                        $('#search-results').show();
                    } else {
                        $('#search-results').append(
                            '<div class="py-3 text-center text-muted">' +
                            '<i class="fas fa-search mb-2"></i>' +
                            '<p class="mb-0 small">No se encontraron películas</p>' +
                            '</div>'
                        );
                        $('#search-results').show();
                    }
                },
                error: function() {
                    console.error('Error al buscar películas');
                }
            });
        }
    });

    // Seleccionar una película
    $('#search-results').on('click', 'a', function(e) {
        e.preventDefault();
        var id = $(this).data('id');
        var title = $(this).data('title');
        var duracion = $(this).data('duracion');
        var imagen = $(this).data('imagen');
        
        $('#pelicula_search').val(title);
        $('#pelicula_id').val(id);
        $('#duracion_pelicula').val(duracion);
        $('#search-results').hide();
        
        // Mostrar tarjeta de película seleccionada
        $('#movie-title').text(title);
        $('#movie-duration').text(duracion);
        
        if (imagen) {
            $('#movie-poster').html('<img src="/storage/' + imagen + '" class="img-fluid rounded" style="width: 50px; height: 70px; object-fit: cover;">');
        } else {
            $('#movie-poster').html('<i class="fas fa-film text-muted fa-2x"></i>');
        }
        
        $('#selected-movie').removeClass('d-none');
        
        // Calcular hora de salida si ya hay hora de entrada
        if ($('#hora_entrada').val()) {
            calcularHoraSalida();
        }
    });

    // Cuando cambia la hora de entrada
    $('#hora_entrada').on('change', function() {
        if ($('#duracion_pelicula').val()) {
            calcularHoraSalida();
        }
    });

    // Función para calcular hora de salida
    function calcularHoraSalida() {
        var horaEntrada = $('#hora_entrada').val();
        var duracion = $('#duracion_pelicula').val();
        
        if (!horaEntrada || !duracion) return;
        
        // Convertir hora de entrada a minutos desde medianoche
        var partesHora = horaEntrada.split(':');
        var horas = parseInt(partesHora[0]);
        var minutos = parseInt(partesHora[1]);
        var totalMinutos = horas * 60 + minutos;
        
        // Sumar la duración de la película
        totalMinutos += parseInt(duracion);
        
        // Convertir de vuelta a formato HH:MM
        var horasSalida = Math.floor(totalMinutos / 60) % 24;
        var minutosSalida = totalMinutos % 60;
        
        // Formatear con ceros a la izquierda
        var horaSalida = 
            (horasSalida < 10 ? '0' + horasSalida : horasSalida) + ':' + 
            (minutosSalida < 10 ? '0' + minutosSalida : minutosSalida);
        
        $('#hora_salida').val(horaSalida);
    }

    // Cerrar resultados al hacer clic fuera
    $(document).on('click', function(e) {
        if (!$(e.target).closest('#pelicula_search, #search-results').length) {
            $('#search-results').hide();
        }
    });

    // Validación de formulario
    $('#alquiler-form').submit(function(e) {
        e.preventDefault();
        
        var horaEntrada = $('#hora_entrada').val();
        var horaSalida = $('#hora_salida').val();
        var pelicula = $('#pelicula_id').val();
        var sala = $('#sala_id').val();
        var cliente = $('#cliente').val();
        var precio = $('#precio').val();

        // Validaciones con nuevos colores
        if (!pelicula) {
            Swal.fire({
                icon: 'warning',
                title: 'Película no seleccionada',
                text: 'Por favor seleccione una película',
                confirmButtonText: 'Entendido',
                confirmButtonColor: '#ff9f10' // Color naranja para advertencias
            });
            return;
        }
        
        if (!sala) {
            Swal.fire({
                icon: 'warning',
                title: 'Sala no seleccionada',
                text: 'Por favor seleccione una sala',
                confirmButtonText: 'Entendido',
                confirmButtonColor: '#ff9f10'
            });
            return;
        }
        
        if (!cliente) {
            Swal.fire({
                icon: 'warning',
                title: 'Cliente requerido',
                text: 'Por favor ingrese el nombre del cliente',
                confirmButtonText: 'Entendido',
                confirmButtonColor: '#ff9f10'
            });
            return;
        }

        if (horaSalida <= horaEntrada) {
            Swal.fire({
                icon: 'error',
                title: 'Error en horario',
                text: 'La hora de salida debe ser posterior a la hora de entrada',
                confirmButtonText: 'Entendido',
                confirmButtonColor: '#ff3b5c' // Color rojo para errores
            });
        } else {
            Swal.fire({
                title: 'Confirmar alquiler',
                html: `
                    <div class="text-left">
                        <div class="mb-3 text-center">
                            <i class="fas fa-ticket-alt fa-2x" style="color: #00d474;"></i>
                        </div>
                        <div class="d-flex justify-content-between border-bottom py-2">
                            <span>Película:</span>
                            <strong>${$('#pelicula_search').val()}</strong>
                        </div>
                        <div class="d-flex justify-content-between border-bottom py-2">
                            <span>Cliente:</span>
                            <strong>${cliente}</strong>
                        </div>
                        <div class="d-flex justify-content-between border-bottom py-2">
                            <span>Horario:</span>
                            <strong>${horaEntrada} - ${horaSalida}</strong>
                        </div>
                        <div class="d-flex justify-content-between py-2">
                            <span>Precio:</span>
                            <strong>S/ ${precio}</strong>
                        </div>
                    </div>
                `,
                showCancelButton: true,
                confirmButtonColor: '#00d474', // Verde para confirmar
                cancelButtonColor: '#64748b',
                confirmButtonText: 'Confirmar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    this.submit();
                }
            });
        }
    });

    // Validación de DNI (solo números)
    $('#dni').on('input', function() {
        this.value = this.value.replace(/[^0-9]/g, '');
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/alquileres/create.blade.php ENDPATH**/ ?>