

<?php $__env->startSection('title', 'Detalle del Producto'); ?>

<?php $__env->startSection('content_header'); ?>
    <div class="d-flex justify-content-between align-items-center">
        <h1 class="m-0 text-dark">
            <i class="fas fa-box-open text-primary mr-2"></i>Detalle del Producto
        </h1>
        <div>
            <a href="<?php echo e(route('productos.edit', $producto->id)); ?>" class="btn btn-warning btn-sm">
                <i class="fas fa-edit mr-1"></i> Editar
            </a>
            <a href="<?php echo e(route('productos.index')); ?>" class="btn btn-secondary btn-sm">
                <i class="fas fa-arrow-left mr-1"></i> Volver
            </a>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <!-- Columna izquierda - Imagen y acciones -->
        <div class="col-md-4">
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="card-title mb-0">Imagen del Producto</h5>
                </div>
                <div class="card-body text-center p-4">
                    <?php if($producto->imagen): ?>
                        <img src="<?php echo e(asset('storage/' . $producto->imagen)); ?>" 
                             class="img-fluid rounded shadow-lg mb-3" 
                             style="max-height: 300px; object-fit: contain;"
                             alt="<?php echo e($producto->nombre); ?>">
                    <?php else: ?>
                        <div class="bg-light p-5 rounded">
                            <i class="fas fa-box-open fa-5x text-muted mb-3"></i>
                            <p class="text-muted">No hay imagen disponible</p>
                        </div>
                    <?php endif; ?>
                    
                    <div class="d-flex justify-content-center mt-3">
                        
                       
                        <button class="btn btn-outline-info btn-sm" data-toggle="modal" data-target="#qrModal">
                            <i class="fas fa-qrcode mr-1"></i> Ver QR
                        </button>
                    </div>
                </div>
            </div>
            
            <!-- Tarjeta de stock -->
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h5 class="card-title mb-0">Gestión de Stock</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <h6 class="font-weight-bold">Nivel de Stock</h6>
                        <div class="progress" style="height: 25px;">
                            <?php
                                $porcentaje = ($producto->stock / ($producto->stock_maximo ?: 100)) * 100;
                                $color = $porcentaje < 20 ? 'bg-danger' : ($porcentaje < 50 ? 'bg-warning' : 'bg-success');
                            ?>
                            <div class="progress-bar <?php echo e($color); ?>" role="progressbar" 
                                 style="width: <?php echo e($porcentaje); ?>%;" 
                                 aria-valuenow="<?php echo e($porcentaje); ?>" 
                                 aria-valuemin="0" 
                                 aria-valuemax="100">
                                <?php echo e($producto->stock); ?> unidades
                            </div>
                        </div>
                        <small class="text-muted">
                            <?php if($producto->stock_maximo): ?>
                                Máximo: <?php echo e($producto->stock_maximo); ?> unidades
                            <?php else: ?>
                                Stock máximo no definido
                            <?php endif; ?>
                        </small>
                    </div>
                    
                    <div class="d-flex justify-content-between">
                        <div class="text-center">
                            <h6 class="font-weight-bold">Última Compra</h6>
                            <p class="mb-0">
                                <?php echo e($producto->ultima_compra ? $producto->ultima_compra->format('d/m/Y') : 'N/A'); ?>

                            </p>
                        </div>
                        <div class="text-center">
                            <h6 class="font-weight-bold">Última Venta</h6>
                            <p class="mb-0">
                                <?php echo e($producto->ultima_venta ? $producto->ultima_venta->format('d/m/Y') : 'N/A'); ?>

                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Columna derecha - Detalles -->
        <div class="col-md-8">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h5 class="card-title mb-0">Información General</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-4">
                                <h6 class="font-weight-bold text-primary">Nombre del Producto</h6>
                                <p class="lead"><?php echo e($producto->nombre); ?></p>
                            </div>
                            
                            <div class="mb-4">
                                <h6 class="font-weight-bold text-primary">Código</h6>
                                <p><?php echo e($producto->codigo ?? 'N/A'); ?></p>
                            </div>
                            
                            <div class="mb-4">
                                <h6 class="font-weight-bold text-primary">Precios</h6>
                                <div class="table-responsive">
                                    <table class="table table-sm table-bordered">
                                        <tr>
                                            <td><strong>Precio de Venta</strong></td>
                                            <td class="text-right">S/ <?php echo e(number_format($producto->precio, 2)); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Precio de Compra</strong></td>
                                            <td class="text-right">S/ <?php echo e(number_format($producto->precio_compra ?? 0, 2)); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Margen de Ganancia</strong></td>
                                            <td class="text-right">
                                                <?php if($producto->precio_compra): ?>
                                                    <?php echo e(number_format((($producto->precio - $producto->precio_compra) / $producto->precio_compra) * 100, 2)); ?>%
                                                <?php else: ?>
                                                    N/A
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-4">
                                <h6 class="font-weight-bold text-primary">Descripción</h6>
                                <p><?php echo e($producto->descripcion ?? 'No especificada'); ?></p>
                            </div>
                            
                            <div class="mb-4">
                                <h6 class="font-weight-bold text-primary">Categoría</h6>
                                <span class="badge badge-primary p-2">
                                    <?php echo e($producto->categoria->nombre ?? 'Sin categoría'); ?>

                                </span>
                            </div>
                            
                            <div class="mb-4">
                                <h6 class="font-weight-bold text-primary">Estado Actual</h6>
                                <?php if($producto->stock == 0): ?>
                                    <span class="badge badge-danger p-2">
                                        <i class="fas fa-times-circle mr-1"></i> Agotado
                                    </span>
                                <?php elseif($producto->stock < 5): ?>
                                    <span class="badge badge-warning p-2">
                                        <i class="fas fa-exclamation-triangle mr-1"></i> Stock Bajo
                                    </span>
                                <?php else: ?>
                                    <span class="badge badge-success p-2">
                                        <i class="fas fa-check-circle mr-1"></i> Disponible
                                    </span>
                                <?php endif; ?>
                            </div>
                            
                            <div class="mb-4">
                                <h6 class="font-weight-bold text-primary">Fecha de Registro</h6>
                                <p><?php echo e($producto->created_at->format('d/m/Y H:i')); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal QR -->
<div class="modal fade" id="qrModal" tabindex="-1" role="dialog" aria-labelledby="qrModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="qrModalLabel">Código QR del Producto</h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body text-center">
                <div id="qrcode" class="mb-3"></div>
                <p class="small text-muted">Escanea este código para acceder rápidamente a la información del producto</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-primary" onclick="downloadQR()">
                    <i class="fas fa-download mr-1"></i> Descargar
                </button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<style>
    .card {
        border-radius: 10px;
        overflow: hidden;
    }
    .card-header {
        padding: 12px 20px;
    }
    .progress {
        border-radius: 20px;
    }
    .progress-bar {
        font-size: 0.85rem;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    #qrcode {
        display: inline-block;
        padding: 10px;
        border: 1px solid #eee;
    }
    @media print {
        .no-print {
            display: none !important;
        }
        .card {
            border: none;
            box-shadow: none;
        }
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="https://cdn.rawgit.com/davidshimjs/qrcodejs/gh-pages/qrcode.min.js"></script>
<script>
$(document).ready(function() {
    // Generar QR
    new QRCode(document.getElementById("qrcode"), {
        text: "<?php echo e(route('productos.show', $producto->id)); ?>",
        width: 200,
        height: 200,
        colorDark : "#000000",
        colorLight : "#ffffff",
        correctLevel : QRCode.CorrectLevel.H
    });
});

function downloadQR() {
    const canvas = document.querySelector("#qrcode canvas");
    const link = document.createElement('a');
    link.download = 'QR-<?php echo e(Str::slug($producto->nombre)); ?>.png';
    link.href = canvas.toDataURL('image/png');
    link.click();
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/productos/show.blade.php ENDPATH**/ ?>