

<?php $__env->startSection('title', 'Lista de Salas de Cine'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1 class="text-center mb-4"><i class="fas fa-film"></i> Salas de Cine</h1>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <!-- Header con acciones -->
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-center align-items-md-center mb-4 gap-3">
        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#modalAgregarSala">
            <i class="fas fa-plus-circle me-1"></i> Agregar Sala
        </button>
        <div class="d-flex gap-2">
            <a href="<?php echo e(route('salas.export-pdf')); ?>" class="btn btn-danger btn-sm text-white" target="_blank">
                <i class="fas fa-file-pdf me-1"></i> PDF
            </a>
            <button class="btn btn-success btn-sm text-white">
                <i class="fas fa-file-excel me-1"></i> Excel
            </button>
        </div>
    </div>

    <!-- Tarjetas de salas - Manteniendo tu diseño original -->
    <div class="row g-4">
        <?php $__currentLoopData = $salas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sala): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-xl-3 col-lg-4 col-md-6">
            <div class="card cinema-card h-100 <?php echo e($sala->tipo == 'VIP' ? 'vip' : 'normal'); ?>" 
                 data-sala-type="<?php echo e(strtolower($sala->tipo)); ?>" 
                 data-sala-status="<?php echo e(strtolower($sala->estado)); ?>">
                <div class="card-header cinema-header d-flex justify-content-between align-items-center">
                    <h3 class="cinema-title mb-0">
                        <i class="fas fa-tv me-2"></i><?php echo e(strtoupper($sala->nombre)); ?>

                    </h3>

                    <?php if(strtolower($sala->estado) == 'disponible'): ?>
                        <span class="cinema-badge available">
                            <i class="fas fa-check-circle me-1"></i> Disponible
                        </span>
                    <?php elseif(strtolower($sala->estado) == 'ocupado'): ?>
                        <span class="cinema-badge occupied">
                            <i class="fas fa-exclamation-triangle me-1"></i> Ocupada
                        </span>
                    <?php elseif(strtolower($sala->estado) == 'mantenimiento'): ?>
                        <span class="cinema-badge maintenance">
                            <i class="fas fa-tools me-1"></i> Mantenimiento
                        </span>
                    <?php else: ?>
                        <span class="cinema-badge unknown">
                            <i class="fas fa-question-circle me-1"></i> Desconocido
                        </span>
                    <?php endif; ?>
                </div>
                
                <div class="card-body cinema-body">
                    <!-- Info de la sala -->
                    <div class="cinema-info mb-4">
                        <div class="cinema-info-item">
                            <div class="cinema-info-icon">
                                <i class="fas fa-users"></i>
                            </div>
                            <div class="cinema-info-content">
                                <span class="cinema-info-label">Capacidad</span>
                                <span class="cinema-info-value"><?php echo e($sala->capacidad); ?> personas</span>
                            </div>
                        </div>
                        
                        <div class="cinema-info-item">
                            <div class="cinema-info-icon">
                                <i class="fas <?php echo e($sala->tipo == 'VIP' ? 'fa-crown' : 'fa-ticket-alt'); ?>"></i>
                            </div>
                            <div class="cinema-info-content">
                                <span class="cinema-info-label">Tipo</span>
                                <span class="cinema-info-value <?php echo e($sala->tipo == 'VIP' ? 'vip-text' : ''); ?>">
                                    <?php echo e($sala->tipo); ?>

                                </span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Acciones -->
                    <div class="cinema-actions">
                        <a href="<?php echo e(route('salas.edit', $sala)); ?>" class="btn-cinema-action edit" title="Editar">
                            <i class="fas fa-edit"></i>
                        </a>
                        
                        <?php if(strtolower($sala->estado) == 'disponible'): ?>
                            <a href="<?php echo e(route('alquileres.create', $sala)); ?>" class="btn-cinema-action rent" title="Alquilar">
                                <i class="fas fa-calendar-check"></i>
                            </a>
                        <?php else: ?>
                            <button class="btn-cinema-action disabled" disabled title="No disponible">
                                <i class="fas fa-ban"></i>
                            </button>
                        <?php endif; ?>
                        
                        <form action="<?php echo e(route('salas.destroy', $sala)); ?>" method="POST" class="d-inline delete-form">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="button" class="btn-cinema-action delete delete-btn" title="Eliminar">
                                <i class="fas fa-trash-alt"></i>
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <!-- Paginación -->
    <div class="d-flex justify-content-center mt-5">
        <?php echo e($salas->links('pagination::bootstrap-5')); ?>

    </div>
</div>

<!-- Modal para Agregar Sala -->
<div class="modal fade" id="modalAgregarSala" tabindex="-1" aria-labelledby="modalAgregarSalaLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content cinema-modal">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="modalAgregarSalaLabel">
                    <i class="fas fa-plus-circle me-2"></i>Agregar Nueva Sala
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="formAgregarSala" method="POST" action="<?php echo e(route('salas.store')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="cinema-form-group">
                                <label for="nombre">Nombre de la Sala</label>
                                <input type="text" class="form-control cinema-input" id="nombre" name="nombre" required value="<?php echo e(old('nombre')); ?>">
                                <small class="form-text text-muted">Ejemplo: SALA 1, SALA VIP 1, etc.</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="cinema-form-group">
                                <label for="capacidad">Capacidad</label>
                                <input type="number" class="form-control cinema-input" id="capacidad" name="capacidad" required value="<?php echo e(old('capacidad')); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="cinema-form-group">
                                <label for="estado">Estado</label>
                                <select class="form-select cinema-select" id="estado" name="estado" required>
                                    <option value="Disponible" <?php echo e(old('estado') == 'Disponible' ? 'selected' : ''); ?>>Disponible</option>
                                    <option value="Ocupado" <?php echo e(old('estado') == 'Ocupado' ? 'selected' : ''); ?>>Ocupado</option>
                                    <option value="Mantenimiento" <?php echo e(old('estado') == 'Mantenimiento' ? 'selected' : ''); ?>>Mantenimiento</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="cinema-form-group">
                                <label for="tipo">Tipo de Sala</label>
                                <select class="form-select cinema-select" id="tipo" name="tipo" required>
                                    <option value="Normal" <?php echo e(old('tipo') == 'Normal' ? 'selected' : ''); ?>>Normal</option>
                                    <option value="VIP" <?php echo e(old('tipo') == 'VIP' ? 'selected' : ''); ?>>VIP</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer border-0">
                        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary btn-sm">
                            <i class="fas fa-save me-1"></i>Guardar
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

   
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<style>
:root {
    --color-primary: #3a0ca3;
    --color-secondary: #4361ee;
    --color-accent: #7209b7;
    --color-success: #27ae60;  /* Verde principal */
    --color-danger: #e74c3c;
    --color-warning: #ffaa00;
    --color-dark: #1d3557;
    --color-light: #f8f9fa;
    --color-vip: #f7b801;
    --color-muted: #6c757d;
    --color-normal: #4cc9f0;
    --color-available: #38b000;
    --color-occupied: #ffaa00;
    --color-maintenance: #2b2d42;
    --font-main: 'Montserrat', sans-serif;
    --shadow-sm: 0 .125rem .25rem rgba(0,0,0,.075);
    --shadow: 0 .5rem 1rem rgba(0,0,0,.15);
    --shadow-lg: 0 1rem 3rem rgba(0,0,0,.175);
    --radius: 12px;
    --transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
}

/* Estilos generales */
body {
    font-family: var(--font-main);
}

h1, h2, h3, h4, h5, h6 {
    font-family: var(--font-main);
    font-weight: 700;
}

.content-header h1 {
    color: var(--color-dark);
    font-size: 2.2rem;
    text-transform: uppercase;
    letter-spacing: 1px;
    font-weight: 700;
    position: relative;
    display: inline-block;
    padding-bottom: 15px;
}

.content-header h1:after {
    content: '';
    position: absolute;
    left: 50%;
    bottom: 0;
    transform: translateX(-50%);
    height: 4px;
    width: 80px;
    background: linear-gradient(90deg, var(--color-primary), var(--color-secondary));
    border-radius: 2px;
}

/* Botones personalizados - Modificados para ser más pequeños */
.btn-cinema-primary, .btn-primary {
    background: var(--color-success);
    border: none;
    color: white;
    font-weight: 600;
    border-radius: var(--radius);
    padding: 0.25rem 0.5rem;
    font-size: 0.875rem;
    box-shadow: var(--shadow-sm);
    transition: var(--transition);
}

.btn-cinema-primary:hover, .btn-primary:hover {
    background: #219150; /* Verde hover */
    box-shadow: var(--shadow);
    transform: translateY(-2px);
    color: white;
}

.btn-cinema-danger, .btn-danger {
    background: var(--color-danger);
    border: none;
    color: white;
    font-weight: 600;
    border-radius: var(--radius);
    padding: 0.25rem 0.5rem;
    font-size: 0.875rem;
    box-shadow: var(--shadow-sm);
    transition: var(--transition);
}

.btn-cinema-danger:hover, .btn-danger:hover {
    box-shadow: var(--shadow);
    transform: translateY(-2px);
    filter: brightness(1.1);
    color: white;
}

.btn-cinema-success, .btn-success {
    background: var(--color-success);
    border: none;
    color: white;
    font-weight: 600;
    border-radius: var(--radius);
    padding: 0.25rem 0.5rem;
    font-size: 0.875rem;
    box-shadow: var(--shadow-sm);
    transition: var(--transition);
}

.btn-cinema-success:hover, .btn-success:hover {
    box-shadow: var(--shadow);
    transform: translateY(-2px);
    filter: brightness(1.1);
    color: white;
}

.btn-cinema-secondary, .btn-secondary {
    background: var(--color-light);
    border: 1px solid var(--color-muted);
    color: var(--color-dark);
    font-weight: 600;
    border-radius: var(--radius);
    padding: 0.25rem 0.5rem;
    font-size: 0.875rem;
    transition: var(--transition);
}

.btn-cinema-secondary:hover, .btn-secondary:hover {
    background: var(--color-muted);
    color: var(--color-light);
}

/* Tarjetas de sala - Manteniendo tu diseño original */
.cinema-card {
    border: none;
    border-radius: var(--radius);
    background: white;
    overflow: hidden;
    box-shadow: var(--shadow-sm);
    transition: var(--transition);
    transform-origin: center;
    position: relative;
}

.cinema-card:hover {
    box-shadow: var(--shadow);
    transform: translateY(-5px) scale(1.01);
}

.cinema-card.normal {
    background: linear-gradient(to bottom, rgba(76, 201, 240, 0.05), rgba(76, 201, 240, 0.02));
    border-top: 3px solid var(--color-normal);
}

.cinema-card.vip {
    background: linear-gradient(to bottom, rgba(247, 184, 1, 0.05), rgba(247, 184, 1, 0.02));
    border-top: 3px solid var(--color-vip);
}

.cinema-header {
    background: none;
    padding: 1.5rem 1.5rem 0.75rem;
    border-bottom: none;
}

.cinema-title {
    font-weight: 700;
    font-size: 1.25rem;
    color: var(--color-dark);
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.cinema-badge {
    padding: 5px 12px;
    border-radius: 100px;
    font-size: 0.8rem;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 5px;
}

.cinema-badge.available {
    background-color: rgba(56, 176, 0, 0.1);
    color: var(--color-available);
}

.cinema-badge.occupied {
    background-color: rgba(255, 170, 0, 0.1);
    color: var(--color-occupied);
}

.cinema-badge.maintenance {
    background-color: rgba(43, 45, 66, 0.1);
    color: var(--color-maintenance);
}

.cinema-badge.unknown {
    background-color: rgba(108, 117, 125, 0.1);
    color: var(--color-muted);
}

.cinema-body {
    padding: 0.75rem 1.5rem 1.5rem;
}

.cinema-info {
    background: var(--color-light);
    border-radius: var(--radius);
    padding: 1rem;
}

.cinema-info-item {
    display: flex;
    align-items: center;
    margin-bottom: 0.75rem;
}

.cinema-info-item:last-child {
    margin-bottom: 0;
}

.cinema-info-icon {
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: white;
    border-radius: 50%;
    margin-right: 1rem;
    box-shadow: var(--shadow-sm);
    font-size: 1rem;
    color: var(--color-primary);
}

.vip .cinema-info-icon {
    color: var(--color-vip);
}

.cinema-info-content {
    flex: 1;
}

.cinema-info-label {
    display: block;
    font-size: 0.8rem;
    font-weight: 500;
    color: var(--color-muted);
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.cinema-info-value {
    display: block;
    font-size: 1rem;
    font-weight: 600;
    color: var(--color-dark);
}

.vip-text {
    color: var(--color-vip);
}

.cinema-actions {
    display: flex;
    justify-content: center;
    gap: 10px;
    margin-top: 1.5rem;
}

.btn-cinema-action {
    width: 45px;
    height: 45px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 50%;
    color: white;
    font-size: 1rem;
    transition: var(--transition);
    border: none;
    cursor: pointer;
    box-shadow: var(--shadow-sm);
}

.btn-cinema-action:hover {
    box-shadow: var(--shadow);
    transform: translateY(-2px);
}

.btn-cinema-action.edit {
    background: var(--color-secondary);
}

.btn-cinema-action.rent {
    background: var(--color-success);
}

.btn-cinema-action.delete {
    background: var(--color-danger);
}

.btn-cinema-action.disabled {
    background: var(--color-muted);
    cursor: not-allowed;
}

/* Modal personalizado */
.cinema-modal .modal-header {
    background: linear-gradient(135deg, var(--color-primary), var(--color-secondary));
    color: white;
    border-radius: calc(var(--radius) - 1px) calc(var(--radius) - 1px) 0 0;
    border-bottom: none;
}

.cinema-modal .modal-content {
    border: none;
    border-radius: var(--radius);
    box-shadow: var(--shadow-lg);
}

.cinema-modal .btn-close {
    filter: brightness(0) invert(1);
}

.cinema-form-group {
    margin-bottom: 1.5rem;
}

.cinema-form-group label {
    display: block;
    font-weight: 600;
    font-size: 0.9rem;
    margin-bottom: 0.5rem;
    color: var(--color-dark);
}

.cinema-input, .cinema-select {
    display: block;
    width: 100%;
    padding: 0.75rem 1rem;
    font-size: 1rem;
    font-weight: 500;
    line-height: 1.5;
    color: var(--color-dark);
    background-color: var(--color-light);
    background-clip: padding-box;
    border: 2px solid transparent;
    border-radius: var(--radius);
    transition: var(--transition);
}

.cinema-input:focus, .cinema-select:focus {
    border-color: var(--color-secondary);
    box-shadow: 0 0 0 0.25rem rgba(67, 97, 238, 0.25);
    outline: 0;
}

/* Paginación personalizada */
.pagination {
    gap: 5px;
}

.pagination .page-item:first-child .page-link,
.pagination .page-item:last-child .page-link {
    border-radius: var(--radius);
}

.pagination .page-item .page-link {
    border: none;
    border-radius: var(--radius);
    color: var(--color-dark);
    font-weight: 600;
    background-color: var(--color-light);
    box-shadow: var(--shadow-sm);
    transition: var(--transition);
}

.pagination .page-item .page-link:hover {
    background-color: var(--color-secondary);
    color: white;
    box-shadow: var(--shadow);
}

.pagination .page-item.active .page-link {
    background-color: var(--color-primary);
    color: white;
}

/* Animaciones */
@keyframes fadeIn {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

.cinema-card {
    animation: fadeIn 0.3s ease forwards;
    animation-delay: calc(var(--animation-order) * 0.1s);
    opacity: 0;
}

/* Responsive */
@media (max-width: 768px) {
    .d-flex {
        flex-direction: column;
        align-items: stretch;
    }
    
    .gap-2 {
        gap: 0.5rem !important;
    }
    
    .btn {
        width: 100%;
        margin-bottom: 0.5rem;
    }
    
    .cinema-card {
        margin-bottom: 1rem;
    }
    
    .cinema-actions {
        flex-wrap: wrap;
    }
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Agrega clases de animación a las tarjetas
    document.querySelectorAll('.cinema-card').forEach((card, index) => {
        card.style.setProperty('--animation-order', index + 1);
    });
    
    // Confirmación para eliminar con SweetAlert2
    document.querySelectorAll('.delete-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            Swal.fire({
                title: '¿Eliminar esta sala?',
                text: "Esta acción no se puede deshacer",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#27ae60',
                cancelButtonColor: '#e74c3c',
                confirmButtonText: 'Sí, eliminar',
                cancelButtonText: 'Cancelar',
                background: '#fff',
                borderRadius: 12,
                iconColor: '#e74c3c',
                customClass: {
                    confirmButton: 'btn btn-sm',
                    cancelButton: 'btn btn-sm'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    this.closest('form').submit();
                }
            });
        });
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/salas/index.blade.php ENDPATH**/ ?>