

<?php $__env->startSection('title', 'Detalles de Película'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1 class="m-0 text-dark">
        <i class="fas fa-film"></i> Detalles de Película
    </h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card card-outline card-primary">
            <div class="card-header">
                <h3 class="card-title"><?php echo e($pelicula->titulo); ?></h3>
                <div class="card-tools">
                    <span class="badge bg-primary">#<?php echo e($pelicula->id); ?></span>
                </div>
            </div>
            
            <div class="card-body">
                <div class="row">
                    <div class="col-md-5 text-center">
                        <img src="<?php echo e(asset('imagenes/logo3.png')); ?>" 
                             alt="<?php echo e($pelicula->titulo); ?>" 
                             class="img-fluid rounded" style="max-height: 400px;">
                        <div class="mt-2">
                            <span class="badge <?php echo e($pelicula->estado == 'disponible' ? 'bg-success' : 'bg-danger'); ?>">
                                <?php echo e(ucfirst($pelicula->estado)); ?>

                            </span>
                        </div>
                    </div>
                    
                    <div class="col-md-7">
                        <div class="info-box bg-light mb-3">
                            <span class="info-box-icon bg-info">
                                <i class="far fa-clock"></i>
                            </span>
                            <div class="info-box-content">
                                <span class="info-box-text">Duración</span>
                                <span class="info-box-number">
                                    <?php echo e(floor($pelicula->duracion / 60)); ?>h <?php echo e($pelicula->duracion % 60); ?>min
                                </span>
                            </div>
                        </div>
                        
                        <div class="info-box bg-light mb-3">
                            <span class="info-box-icon bg-purple">
                                <i class="fas fa-compact-disc"></i>
                            </span>
                            <div class="info-box-content">
                                <span class="info-box-text">Formato</span>
                                <span class="info-box-number"><?php echo e($pelicula->formato); ?></span>
                            </div>
                        </div>
                        
                        <div class="info-box bg-light mb-3">
                            <span class="info-box-icon bg-success">
                                <i class="fas fa-tag"></i>
                            </span>
                            <div class="info-box-content">
                                <span class="info-box-text">Categoría</span>
                                <span class="info-box-number"><?php echo e($pelicula->categoria->nombre); ?></span>
                            </div>
                        </div>
                        
                        <div class="timeline">
                            <div class="time-label">
                                <span class="bg-blue">Historial</span>
                            </div>
                            <div>
                                <i class="fas fa-plus bg-blue"></i>
                                <div class="timeline-item">
                                    <span class="time">
                                        <i class="far fa-clock"></i> <?php echo e($pelicula->created_at->format('H:i')); ?>

                                    </span>
                                    <h3 class="timeline-header">Creación</h3>
                                    <div class="timeline-body">
                                        <?php echo e($pelicula->created_at->format('d M, Y')); ?>

                                    </div>
                                </div>
                            </div>
                            <div>
                                <i class="fas fa-sync-alt bg-blue"></i>
                                <div class="timeline-item">
                                    <span class="time">
                                        <i class="far fa-clock"></i> <?php echo e($pelicula->updated_at->format('H:i')); ?>

                                    </span>
                                    <h3 class="timeline-header">Última actualización</h3>
                                    <div class="timeline-body">
                                        <?php echo e($pelicula->updated_at->format('d M, Y')); ?>

                                    </div>
                                </div>
                            </div>
                            <div>
                                <i class="far fa-clock bg-gray"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-6 mb-2 mb-md-0">
                        <a href="<?php echo e(route('peliculas.index')); ?>" class="btn btn-default btn-block">
                            <i class="fas fa-arrow-left"></i> Volver
                        </a>
                    </div>
                    <div class="col-md-6">
                        <div class="d-flex">
                            <a href="<?php echo e(route('peliculas.edit', $pelicula)); ?>" class="btn btn-primary mr-2 flex-grow-1">
                                <i class="fas fa-edit"></i> Editar
                            </a>
                            <button class="btn btn-danger flex-grow-1" id="deleteBtn">
                                <i class="fas fa-trash"></i> Eliminar
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<form action="<?php echo e(route('peliculas.destroy', $pelicula)); ?>" method="POST" id="deleteForm" class="d-none">
    <?php echo csrf_field(); ?>
    <?php echo method_field('DELETE'); ?>
</form>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
    document.getElementById('deleteBtn').addEventListener('click', function() {
        Swal.fire({
            title: '¿Eliminar película?',
            text: "Esta acción no se puede deshacer",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById('deleteForm').submit();
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/peliculas/show.blade.php ENDPATH**/ ?>