<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Ticket</title>
    <style>
        body {
            font-family: monospace;
            font-size: 12px;
            padding: 10px;
        }
        html, body {
    height: auto;
    max-height: 100%;
    overflow: hidden;
}
        h2, h4 {
            text-align: center;
            margin: 0;
        }
        .line {
            border-top: 1px dashed #000;
            margin: 5px 0;
        }
        .center {
            text-align: center;
        }
        .qr {
    display: flex;
    justify-content: center;
    margin: 10px 0;
}
.qr img {
    width: 80px;
    height: 80px;
}

    </style>
</head>
<body>
<h2 class="center">CINESTACIÓN</h2>
<p class="center"><strong>RUC:</strong> 12345678901</p>
<p class="center">Av. Películas #123 - Lima</p>
<div class="line"></div>

<?php
    // Si alquiler existe y su campo cliente tiene texto
    $clienteTexto = $venta->alquiler && $venta->alquiler->cliente 
        ? $venta->alquiler->cliente 
        : 'Venta directa';

    // Generar código de ticket
    $iniciales = strtoupper(substr(preg_replace('/[^A-Z]/', '', $clienteTexto), 0, 2));
    $codigo = "VENTA-{$iniciales}-{$venta->id}";
?>

    
    
    <p><strong>Ticket:</strong> #<?php echo e($venta->id); ?></p>
    <p><strong>Fecha:</strong> <?php echo e($venta->created_at->format('d/m/Y H:i')); ?></p>
    <p><strong>Cliente:</strong> <?php echo e($clienteTexto); ?></p>

    <div class="line"></div>
    <p><strong>Productos:</strong></p>

    <?php $__currentLoopData = $venta->detalles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <p>- <?php echo e($d->producto->nombre ?? 'Producto eliminado'); ?> x<?php echo e($d->cantidad); ?> | S/ <?php echo e(number_format($d->subtotal, 2)); ?></p>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <div class="line"></div>
    <p><strong>Total:</strong> S/ <?php echo e(number_format($venta->detalles->sum('subtotal'), 2)); ?></p>
    <p><strong>Estado:</strong> <?php echo e(ucfirst($venta->estado)); ?></p>
    <p><strong>Método de Pago:</strong> <?php echo e($venta->metodo_pago ?? '---'); ?></p>
    <p><strong>Código:</strong> <?php echo e($codigo); ?></p>
    <div class="line"></div>
    <div class="qr center">
    <img src="<?php echo e($qrSrc); ?>" alt="QR Código">
</div>
    <p class="center">Escanea para validar</p>
    <div class="line"></div>
    <p class="center">¡Gracias por su compra!</p>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/ventas/ticket-pdf.blade.php ENDPATH**/ ?>