<aside class="main-sidebar {{ config('adminlte.classes_sidebar', 'sidebar-dark-primary elevation-4') }}"
       @if(config('adminlte.sidebar_bg_img'))
           style="background: url('{{ asset(config('adminlte.sidebar_bg_img')) }}') no-repeat center center; background-size: cover;"
       @endif>

    {{-- Sidebar brand logo --}}
    @if(config('adminlte.logo_img_xl'))
        @include('adminlte::partials.common.brand-logo-xl')
    @else
        @include('adminlte::partials.common.brand-logo-xs')
    @endif

    {{-- Sidebar menu --}}
    <div class="sidebar glass-sidebar">
        <nav class="pt-2">
            <ul class="nav nav-pills nav-sidebar flex-column {{ config('adminlte.classes_sidebar_nav', '') }} minimal-sidebar"
                data-widget="treeview" role="menu"
                @if(config('adminlte.sidebar_nav_animation_speed') != 300)
                    data-animation-speed="{{ config('adminlte.sidebar_nav_animation_speed') }}"
                @endif
                @if(!config('adminlte.sidebar_nav_accordion'))
                    data-accordion="false"
                @endif>
                
                {{-- Configured sidebar links --}}
                @each('adminlte::partials.sidebar.menu-item', $adminlte->menu('sidebar'), 'item')
            </ul>
        </nav>
    </div>

    {{-- Estilos personalizados para Sidebar Minimalista --}}
    <style>
    :root {
        /* Modo Claro */
        --sidebar-bg-light: rgba(255, 255, 255, 0.85);
        --sidebar-border-light: rgba(0, 0, 0, 0.08);
        --text-light: #2d3748;
        --text-hover-light: #4a5568;
        --icon-light: #4a5568;
        --active-light: #4299e1;
        --active-bg-light: rgba(66, 153, 225, 0.1);
        
        /* Modo Oscuro */
        --sidebar-bg-dark: rgba(26, 32, 44, 0.95);
        --sidebar-border-dark: rgba(255, 255, 255, 0.08);
        --text-dark: #e2e8f0;
        --text-hover-dark: #cbd5e0;
        --icon-dark: #a0aec0;
        --active-dark: #63b3ed;
        --active-bg-dark: rgba(99, 179, 237, 0.1);
    }

    /* Efecto glassmorphism */
    .glass-sidebar {
        backdrop-filter: blur(12px);
        -webkit-backdrop-filter: blur(12px);
        background: var(--sidebar-bg-light);
        border-right: 1px solid var(--sidebar-border-light);
        box-shadow: 0 4px 30px rgba(0, 0, 0, 0.1);
        transition: all 0.3s ease;
    }

    .dark-mode .glass-sidebar {
        background: var(--sidebar-bg-dark);
        border-right: 1px solid var(--sidebar-border-dark);
    }

    /* Estructura minimalista */
    .minimal-sidebar {
        padding: 0.5rem;
    }

    .minimal-sidebar .nav-item {
        margin-bottom: 0.25rem;
        transition: all 0.2s ease;
    }

    .minimal-sidebar .nav-link {
        color: var(--text-light);
        border-radius: 8px;
        padding: 0.75rem 1rem;
        font-weight: 500;
        display: flex;
        align-items: center;
        transition: all 0.2s ease;
    }

    .minimal-sidebar .nav-icon {
        color: var(--icon-light);
        margin-right: 0.75rem;
        font-size: 1.1rem;
        transition: all 0.2s ease;
    }

    .minimal-sidebar .nav-link:hover {
        color: var(--text-hover-light);
        background-color: rgba(0, 0, 0, 0.03);
        transform: translateX(3px);
    }

    .minimal-sidebar .nav-link:hover .nav-icon {
        color: var(--text-hover-light);
        transform: scale(1.1);
    }

    .minimal-sidebar .nav-link.active {
        color: var(--active-light);
        background-color: var(--active-bg-light);
        font-weight: 600;
    }

    .minimal-sidebar .nav-link.active .nav-icon {
        color: var(--active-light);
    }

    /* Modo oscuro */
    .dark-mode .minimal-sidebar .nav-link {
        color: var(--text-dark);
    }

    .dark-mode .minimal-sidebar .nav-icon {
        color: var(--icon-dark);
    }

    .dark-mode .minimal-sidebar .nav-link:hover {
        color: var(--text-hover-dark);
        background-color: rgba(255, 255, 255, 0.05);
    }

    .dark-mode .minimal-sidebar .nav-link:hover .nav-icon {
        color: var(--text-hover-dark);
    }

    .dark-mode .minimal-sidebar .nav-link.active {
        color: var(--active-dark);
        background-color: var(--active-bg-dark);
    }

    .dark-mode .minimal-sidebar .nav-link.active .nav-icon {
        color: var(--active-dark);
    }

    /* Treeview (submenús) */
    .minimal-sidebar .nav-treeview {
        padding-left: 1.5rem;
    }

    .minimal-sidebar .nav-treeview .nav-link {
        padding: 0.5rem 1rem 0.5rem 2rem;
        font-size: 0.9rem;
    }

    /* Scrollbar personalizada */
    .glass-sidebar::-webkit-scrollbar {
        width: 6px;
    }

    .glass-sidebar::-webkit-scrollbar-track {
        background: transparent;
    }

    .glass-sidebar::-webkit-scrollbar-thumb {
        background-color: rgba(0, 0, 0, 0.2);
        border-radius: 3px;
    }

    .dark-mode .glass-sidebar::-webkit-scrollbar-thumb {
        background-color: rgba(255, 255, 255, 0.2);
    }

    /* Logo y marca */
    .brand-link {
        border-bottom: none;
        padding: 1rem 0.5rem;
        transition: all 0.3s ease;
    }

    .brand-link:hover {
        opacity: 0.9;
    }

    /* Transiciones suaves */
    * {
        transition: background-color 0.3s ease, color 0.2s ease;
    }
</style>

</aside>